/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.jdk.Target_java_lang_ClassLoader;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class JavaLangSubstitutions {

    static class ClassValueInitializer
    implements RecomputeFieldValue.CustomFieldValueComputer {
        ClassValueInitializer() {
        }

        @Override
        public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
            ClassValueSupport support = (ClassValueSupport)ImageSingletons.lookup(ClassValueSupport.class);
            ClassValue v = (ClassValue)receiver;
            Map<Class<?>, Object> map = support.values.get(v);
            assert (map != null);
            return map;
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final class ClassValueSupport {
        final Map<ClassValue<?>, Map<Class<?>, Object>> values;

        public ClassValueSupport(Map<ClassValue<?>, Map<Class<?>, Object>> map) {
            this.values = map;
        }
    }

    public static class ClassLoaderSupport {
        public Target_java_lang_ClassLoader systemClassLoader;
        public Target_java_lang_ClassLoader platformClassLoader;
        @Platforms(value={Platform.HOSTED_ONLY.class})
        public Map<ClassLoader, Target_java_lang_ClassLoader> classLoaders = Collections.synchronizedMap(new IdentityHashMap());

        @Fold
        public static ClassLoaderSupport getInstance() {
            return (ClassLoaderSupport)ImageSingletons.lookup(ClassLoaderSupport.class);
        }

        public Target_java_lang_ClassLoader getOrCreate(ClassLoader classLoader) {
            this.createClassLoaders(classLoader);
            return this.classLoaders.get(classLoader);
        }

        public void createClassLoaders(ClassLoader loader) {
            if (loader == null) {
                return;
            }
            Map<ClassLoader, Target_java_lang_ClassLoader> loaders = ClassLoaderSupport.getInstance().classLoaders;
            if (!loaders.containsKey(loader)) {
                ClassLoader parent = loader.getParent();
                if (parent != null) {
                    this.createClassLoaders(parent);
                    loaders.put(loader, new Target_java_lang_ClassLoader(loaders.get(parent)));
                } else {
                    loaders.put(loader, new Target_java_lang_ClassLoader());
                }
            }
        }
    }
}

