/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.KeepOriginal;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.heap.FeebleReferenceList;
import com.oracle.svm.core.jdk.ReferenceWrapper;
import com.oracle.svm.core.thread.VMOperation;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;

@TargetClass(value=ReferenceQueue.class)
@Substitute
final class Target_java_lang_ref_ReferenceQueue {
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.NewInstance, declClass=FeebleReferenceList.class)
    protected final FeebleReferenceList<Object> feeble = FeebleReferenceList.factory();

    @Substitute
    protected Target_java_lang_ref_ReferenceQueue() {
    }

    @Substitute
    public Object poll() {
        return ReferenceWrapper.unwrap(this.feeble.pop());
    }

    @Substitute
    public Object remove() throws InterruptedException {
        VMOperation.guaranteeNotInProgress("Calling ReferenceQueue.remove() inside a VMOperation could block the VM operation thread and cause a deadlock.");
        return ReferenceWrapper.unwrap(this.feeble.remove());
    }

    @Substitute
    public Object remove(long timeoutMillis) throws InterruptedException {
        VMOperation.guaranteeNotInProgress("Calling ReferenceQueue.remove(long) inside a VMOperation could block the VM operation thread and cause a deadlock.");
        return ReferenceWrapper.unwrap(this.feeble.remove(timeoutMillis));
    }

    @KeepOriginal
    native boolean enqueue(Reference<?> var1);

    public boolean isEmpty() {
        return this.feeble.isEmpty();
    }
}

