/*
 * Decompiled with CFR 0.152.
 */
package grails.gsp.boot;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.servlet.jsp.tagext.JspTag;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.StandaloneGrailsApplication;
import org.codehaus.groovy.grails.plugins.codecs.StandaloneCodecLookup;
import org.codehaus.groovy.grails.support.encoding.CodecLookup;
import org.codehaus.groovy.grails.web.pages.GroovyPagesTemplateEngine;
import org.codehaus.groovy.grails.web.pages.GroovyPagesTemplateRenderer;
import org.codehaus.groovy.grails.web.pages.StandaloneTagLibraryLookup;
import org.codehaus.groovy.grails.web.pages.discovery.CachingGrailsConventionGroovyPageLocator;
import org.codehaus.groovy.grails.web.pages.discovery.GrailsConventionGroovyPageLocator;
import org.codehaus.groovy.grails.web.pages.discovery.GroovyPageLocator;
import org.codehaus.groovy.grails.web.pages.ext.jsp.TagLibraryResolverImpl;
import org.codehaus.groovy.grails.web.servlet.view.GrailsLayoutViewResolver;
import org.codehaus.groovy.grails.web.servlet.view.GroovyPageViewResolver;
import org.codehaus.groovy.grails.web.sitemesh.GroovyPageLayoutFinder;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.ViewResolver;

@Configuration
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class GspAutoConfiguration {

    @ConditionalOnClass(value={JspTag.class, TagLibraryResolverImpl.class})
    @Configuration
    protected static class GspJspIntegrationConfiguration
    implements EnvironmentAware {
        protected GspJspIntegrationConfiguration() {
        }

        @Bean(autowire=Autowire.BY_NAME)
        public TagLibraryResolverImpl jspTagLibraryResolver() {
            return new TagLibraryResolverImpl();
        }

        public void setEnvironment(Environment environment) {
            if (environment instanceof ConfigurableEnvironment) {
                ConfigurableEnvironment configEnv = (ConfigurableEnvironment)environment;
                Properties defaultProperties = this.createDefaultProperties();
                configEnv.getPropertySources().addLast((PropertySource)new PropertiesPropertySource(GspJspIntegrationConfiguration.class.getName(), defaultProperties));
            }
        }

        protected Properties createDefaultProperties() {
            Properties defaultProperties = new Properties();
            defaultProperties.put("spring.gsp.tldScanPattern", "classpath*:/META-INF/spring*.tld,classpath*:/META-INF/fmt.tld,classpath*:/META-INF/c.tld,classpath*:/META-INF/c-1_0-rt.tld");
            return defaultProperties;
        }
    }

    protected static class RemoveDefaultViewResolverRegistrar
    implements ImportBeanDefinitionRegistrar,
    EnvironmentAware {
        boolean removeDefaultViewResolverBean;
        boolean replaceViewResolverBean;

        protected RemoveDefaultViewResolverRegistrar() {
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            if (this.removeDefaultViewResolverBean && registry.containsBeanDefinition("defaultViewResolver")) {
                registry.removeBeanDefinition("defaultViewResolver");
            }
            if (this.replaceViewResolverBean) {
                if (registry.containsBeanDefinition("viewResolver")) {
                    registry.removeBeanDefinition("viewResolver");
                }
                registry.registerAlias("gspViewResolver", "viewResolver");
            }
        }

        public void setEnvironment(Environment environment) {
            this.removeDefaultViewResolverBean = (Boolean)environment.getProperty("spring.gsp.removeDefaultViewResolverBean", Boolean.class, (Object)true);
            this.replaceViewResolverBean = (Boolean)environment.getProperty("spring.gsp.replaceViewResolverBean", Boolean.class, (Object)true);
        }
    }

    protected static class TagLibraryLookupRegistrar
    implements ImportBeanDefinitionRegistrar {
        protected TagLibraryLookupRegistrar() {
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            if (!registry.containsBeanDefinition("gspTagLibraryLookup")) {
                GenericBeanDefinition beanDefinition = this.createBeanDefinition(StandaloneTagLibraryLookup.class);
                ManagedList list = new ManagedList();
                this.registerTagLibs((ManagedList<BeanDefinition>)list);
                beanDefinition.getPropertyValues().addPropertyValue("tagLibInstances", (Object)list);
                registry.registerBeanDefinition("gspTagLibraryLookup", (BeanDefinition)beanDefinition);
                registry.registerAlias("gspTagLibraryLookup", "tagLibraryLookup");
            }
        }

        protected void registerTagLibs(ManagedList<BeanDefinition> list) {
            for (Class taglibClazz : StandaloneTagLibraryLookup.DEFAULT_TAGLIB_CLASSES) {
                list.add((Object)this.createBeanDefinition(taglibClazz));
            }
        }

        protected GenericBeanDefinition createBeanDefinition(Class<?> beanClass) {
            GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
            beanDefinition.setBeanClass(beanClass);
            beanDefinition.setAutowireMode(1);
            return beanDefinition;
        }
    }

    public static class SpringBootGrailsApplication
    extends StandaloneGrailsApplication
    implements EnvironmentAware {
        private Environment environment;

        public void updateFlatConfig() {
            super.updateFlatConfig();
            if (this.environment instanceof ConfigurableEnvironment) {
                ConfigurableEnvironment configurableEnv = (ConfigurableEnvironment)this.environment;
                for (PropertySource propertySource : configurableEnv.getPropertySources()) {
                    if (!(propertySource instanceof EnumerablePropertySource)) continue;
                    EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
                    for (String propertyName : enumerablePropertySource.getPropertyNames()) {
                        this.flatConfig.put(propertyName, enumerablePropertySource.getProperty(propertyName));
                    }
                }
            }
        }

        public void setEnvironment(Environment environment) {
            this.environment = environment;
            this.updateFlatConfig();
        }
    }

    @Configuration
    protected static class StandaloneGrailsApplicationConfiguration {
        protected StandaloneGrailsApplicationConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"grailsApplication"})
        public GrailsApplication grailsApplication() {
            return new SpringBootGrailsApplication();
        }
    }

    @Configuration
    protected static class CodecLookupConfiguration {
        protected CodecLookupConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"codecLookup"})
        public CodecLookup codecLookup() {
            return new StandaloneCodecLookup();
        }
    }

    @Configuration
    protected static class GspViewResolverConfiguration
    extends AbstractGspConfig {
        @Autowired
        GroovyPagesTemplateEngine groovyPagesTemplateEngine;
        @Autowired
        GrailsConventionGroovyPageLocator groovyPageLocator;
        @Autowired
        GroovyPageLayoutFinder groovyPageLayoutFinder;

        protected GspViewResolverConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"gspViewResolver"})
        public GrailsLayoutViewResolver gspViewResolver() {
            return new GrailsLayoutViewResolver(this.innerGspViewResolver(), this.groovyPageLayoutFinder);
        }

        ViewResolver innerGspViewResolver() {
            GroovyPageViewResolver innerGspViewResolver = new GroovyPageViewResolver(this.groovyPagesTemplateEngine, this.groovyPageLocator);
            innerGspViewResolver.setAllowGrailsViewCaching(!this.gspReloadingEnabled || this.viewCacheTimeout != 0L);
            innerGspViewResolver.setCacheTimeout(this.gspReloadingEnabled ? this.viewCacheTimeout : -1L);
            return innerGspViewResolver;
        }
    }

    @Configuration
    @Import(value={TagLibraryLookupRegistrar.class, RemoveDefaultViewResolverRegistrar.class})
    protected static class GspTemplateEngineAutoConfiguration
    extends AbstractGspConfig {
        private static final String LOCAL_DIRECTORY_TEMPLATE_ROOT = "./src/main/resources/templates";
        private static final String CLASSPATH_TEMPLATE_ROOT = "classpath:/templates";
        @Value(value="${spring.gsp.templateRoots:}")
        String[] templateRoots;
        @Value(value="${spring.gsp.locator.cacheTimeout:5000}")
        long locatorCacheTimeout;
        @Value(value="${spring.gsp.layout.caching:true}")
        boolean gspLayoutCaching;
        @Value(value="${spring.gsp.layout.default:main}")
        String defaultLayoutName;

        protected GspTemplateEngineAutoConfiguration() {
        }

        @Bean(autowire=Autowire.BY_NAME)
        @ConditionalOnMissingBean(name={"groovyPagesTemplateEngine"})
        GroovyPagesTemplateEngine groovyPagesTemplateEngine() {
            GroovyPagesTemplateEngine templateEngine = new GroovyPagesTemplateEngine();
            templateEngine.setReloadEnabled(this.gspReloadingEnabled);
            return templateEngine;
        }

        @Bean(autowire=Autowire.BY_NAME)
        @ConditionalOnMissingBean(name={"groovyPageLocator"})
        GroovyPageLocator groovyPageLocator() {
            final List<String> templateRootsCleaned = this.resolveTemplateRoots();
            CachingGrailsConventionGroovyPageLocator pageLocator = new CachingGrailsConventionGroovyPageLocator(){

                protected List<String> resolveSearchPaths(String uri) {
                    ArrayList<String> paths = new ArrayList<String>(templateRootsCleaned.size());
                    for (String rootPath : templateRootsCleaned) {
                        paths.add(rootPath + this.cleanUri(uri));
                    }
                    return paths;
                }

                protected String cleanUri(String uri) {
                    if (!(uri = StringUtils.cleanPath((String)uri)).startsWith("/")) {
                        uri = "/" + uri;
                    }
                    return uri;
                }
            };
            pageLocator.setReloadEnabled(this.gspReloadingEnabled);
            pageLocator.setCacheTimeout(this.gspReloadingEnabled ? this.locatorCacheTimeout : -1L);
            return pageLocator;
        }

        protected List<String> resolveTemplateRoots() {
            File templateRootDirectory;
            if (this.templateRoots.length > 0) {
                ArrayList<String> rootPaths = new ArrayList<String>(this.templateRoots.length);
                for (String rootPath : this.templateRoots) {
                    if ((rootPath = rootPath.trim()).endsWith("/")) {
                        rootPath = rootPath.substring(0, rootPath.length() - 1);
                    }
                    if (StringUtils.isEmpty((Object)rootPath)) continue;
                    rootPaths.add(rootPath);
                }
                return rootPaths;
            }
            if (this.gspReloadingEnabled && (templateRootDirectory = new File(LOCAL_DIRECTORY_TEMPLATE_ROOT)).isDirectory()) {
                return Collections.singletonList("file:./src/main/resources/templates");
            }
            return Collections.singletonList(CLASSPATH_TEMPLATE_ROOT);
        }

        @Bean
        @ConditionalOnMissingBean(name={"groovyPageLayoutFinder"})
        public GroovyPageLayoutFinder groovyPageLayoutFinder() {
            GroovyPageLayoutFinder groovyPageLayoutFinder = new GroovyPageLayoutFinder();
            groovyPageLayoutFinder.setGspReloadEnabled(this.gspReloadingEnabled);
            groovyPageLayoutFinder.setCacheEnabled(this.gspLayoutCaching);
            groovyPageLayoutFinder.setEnableNonGspViews(false);
            groovyPageLayoutFinder.setDefaultDecoratorName(this.defaultLayoutName);
            return groovyPageLayoutFinder;
        }

        @Bean(autowire=Autowire.BY_NAME)
        @ConditionalOnMissingBean(name={"groovyPagesTemplateRenderer"})
        GroovyPagesTemplateRenderer groovyPagesTemplateRenderer() {
            GroovyPagesTemplateRenderer groovyPagesTemplateRenderer = new GroovyPagesTemplateRenderer();
            groovyPagesTemplateRenderer.setCacheEnabled(!this.gspReloadingEnabled);
            return groovyPagesTemplateRenderer;
        }
    }

    protected static abstract class AbstractGspConfig {
        @Value(value="${spring.gsp.reloadingEnabled:true}")
        boolean gspReloadingEnabled;
        @Value(value="${spring.gsp.view.cacheTimeout:1000}")
        long viewCacheTimeout;

        protected AbstractGspConfig() {
        }
    }
}

