/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl.classFiles;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryClassSignatureParser;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaMethod;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaMethodBase;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaValueParameter;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.ClassifierResolutionContext;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.CommonMixinsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.TypeReference;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0016J\u001a\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\tH\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J,\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/AnnotationsAndParameterCollectorMethodVisitor;", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "member", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryJavaMethodBase;", "context", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;", "signatureParser", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser;", "parametersToSkipNumber", "", "(Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryJavaMethodBase;Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser;I)V", "parameterIndex", "visitAnnotation", "Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "desc", "", "visible", "", "visitAnnotationDefault", "visitParameter", "", "name", "access", "visitParameterAnnotation", "parameter", "visitTypeAnnotation", "typeRef", "typePath", "Lorg/jetbrains/org/objectweb/asm/TypePath;", "frontend.java"})
public final class AnnotationsAndParameterCollectorMethodVisitor
extends MethodVisitor {
    private int parameterIndex;
    private final BinaryJavaMethodBase member;
    private final ClassifierResolutionContext context;
    private final BinaryClassSignatureParser signatureParser;
    private final int parametersToSkipNumber;

    @Override
    @Nullable
    public AnnotationVisitor visitAnnotationDefault() {
        block1: {
            BinaryJavaMethodBase $receiver$iv = this.member;
            BinaryJavaMethodBase binaryJavaMethodBase = $receiver$iv;
            if (!(binaryJavaMethodBase instanceof BinaryJavaMethod)) {
                binaryJavaMethodBase = null;
            }
            BinaryJavaMethod binaryJavaMethod = (BinaryJavaMethod)binaryJavaMethodBase;
            if (binaryJavaMethod == null) break block1;
            binaryJavaMethod.setHasAnnotationParameterDefaultValue(true);
        }
        return null;
    }

    @Override
    public void visitParameter(@Nullable String name, int access) {
        int index2;
        if (name != null && (index2 = this.parameterIndex - this.parametersToSkipNumber) >= 0) {
            BinaryJavaValueParameter binaryJavaValueParameter = (BinaryJavaValueParameter)CollectionsKt.getOrNull(this.member.getValueParameters(), (int)index2);
            if (binaryJavaValueParameter == null) {
                String string = "No parameter with index " + this.parameterIndex + '-' + this.parametersToSkipNumber + " (name=" + name + " access=" + access + ") " + "in method " + this.member.getContainingClass().getFqName() + '.' + this.member.getName();
                throw (Throwable)new IllegalStateException(string.toString());
            }
            BinaryJavaValueParameter parameter = binaryJavaValueParameter;
            Name name2 = Name.identifier(name);
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(name)");
            parameter.updateName$frontend_java(name2);
        }
        int n = this.parameterIndex;
        this.parameterIndex = n + 1;
    }

    @Override
    @NotNull
    public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        Collection<JavaAnnotation> collection = this.member.getAnnotations();
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableCollection<org.jetbrains.kotlin.load.java.structure.JavaAnnotation>");
        }
        return BinaryJavaAnnotation.Companion.addAnnotation(TypeIntrinsics.asMutableCollection(collection), desc, this.context, this.signatureParser);
    }

    @Override
    @Nullable
    public AnnotationVisitor visitParameterAnnotation(int parameter, @NotNull String desc, boolean visible) {
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        int index2 = parameter - this.parametersToSkipNumber;
        if (index2 < 0) {
            return null;
        }
        Collection collection = TypeIntrinsics.asMutableCollection(this.member.getValueParameters().get(index2).getAnnotations());
        if (collection == null) {
            return null;
        }
        Collection annotations2 = collection;
        return BinaryJavaAnnotation.Companion.addAnnotation(annotations2, desc, this.context, this.signatureParser);
    }

    @Override
    @Nullable
    public AnnotationVisitor visitTypeAnnotation(int typeRef, @Nullable TypePath typePath, @NotNull String desc, boolean visible) {
        AnnotationVisitor annotationVisitor;
        Intrinsics.checkParameterIsNotNull((Object)desc, (String)"desc");
        if (typePath != null) {
            return null;
        }
        TypeReference typeReference = new TypeReference(typeRef);
        switch (typeReference.getSort()) {
            case 20: {
                Object object;
                BinaryJavaMethodBase $receiver$iv = this.member;
                BinaryJavaMethodBase binaryJavaMethodBase = $receiver$iv;
                if (!(binaryJavaMethodBase instanceof BinaryJavaMethod)) {
                    binaryJavaMethodBase = null;
                }
                if ((object = (BinaryJavaMethod)binaryJavaMethodBase) != null && (object = ((BinaryJavaMethod)object).getReturnType()) != null) {
                    Object object2;
                    Object it = object2 = object;
                    annotationVisitor = BinaryJavaAnnotation.Companion.addTypeAnnotation((JavaType)it, desc, this.context, this.signatureParser);
                    break;
                }
                annotationVisitor = null;
                break;
            }
            case 22: {
                annotationVisitor = BinaryJavaAnnotation.Companion.addTypeAnnotation(this.member.getValueParameters().get(typeReference.getFormalParameterIndex()).getType(), desc, this.context, this.signatureParser);
                break;
            }
            default: {
                annotationVisitor = null;
            }
        }
        return annotationVisitor;
    }

    public AnnotationsAndParameterCollectorMethodVisitor(@NotNull BinaryJavaMethodBase member, @NotNull ClassifierResolutionContext context, @NotNull BinaryClassSignatureParser signatureParser, int parametersToSkipNumber) {
        Intrinsics.checkParameterIsNotNull((Object)member, (String)"member");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)signatureParser, (String)"signatureParser");
        super(CommonMixinsKt.getASM_API_VERSION_FOR_CLASS_READING());
        this.member = member;
        this.context = context;
        this.signatureParser = signatureParser;
        this.parametersToSkipNumber = parametersToSkipNumber;
    }
}

