/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinUserTypeStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

public class KtUserType
extends KtElementImplStub<KotlinUserTypeStub>
implements KtTypeElement {
    public KtUserType(@NotNull ASTNode node) {
        super(node);
    }

    public KtUserType(@NotNull KotlinUserTypeStub stub2) {
        super(stub2, KtStubElementTypes.USER_TYPE);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        return visitor2.visitUserType(this, data);
    }

    @Nullable
    public KtTypeArgumentList getTypeArgumentList() {
        return (KtTypeArgumentList)this.getStubOrPsiChild(KtStubElementTypes.TYPE_ARGUMENT_LIST);
    }

    @NotNull
    public List<KtTypeProjection> getTypeArguments() {
        KtTypeArgumentList typeArgumentList = this.getTypeArgumentList();
        return typeArgumentList == null ? Collections.emptyList() : typeArgumentList.getArguments();
    }

    @Override
    @NotNull
    public List<KtTypeReference> getTypeArgumentsAsTypes() {
        ArrayList<KtTypeReference> result2 = Lists.newArrayList();
        for (KtTypeProjection projection : this.getTypeArguments()) {
            result2.add(projection.getTypeReference());
        }
        return result2;
    }

    @IfNotParsed
    @Nullable
    public KtSimpleNameExpression getReferenceExpression() {
        KtNameReferenceExpression nameRefExpr = this.getStubOrPsiChild(KtStubElementTypes.REFERENCE_EXPRESSION);
        return nameRefExpr != null ? nameRefExpr : (KtSimpleNameExpression)this.getStubOrPsiChild(KtStubElementTypes.ENUM_ENTRY_SUPERCLASS_REFERENCE_EXPRESSION);
    }

    @Nullable
    public KtUserType getQualifier() {
        return this.getStubOrPsiChild(KtStubElementTypes.USER_TYPE);
    }

    public void deleteQualifier() {
        KtUserType qualifier = this.getQualifier();
        assert (qualifier != null);
        Object dot = this.findChildByType(KtTokens.DOT);
        assert (dot != null);
        qualifier.delete();
        dot.delete();
    }

    @Nullable
    public String getReferencedName() {
        KtSimpleNameExpression referenceExpression = this.getReferenceExpression();
        return referenceExpression == null ? null : referenceExpression.getReferencedName();
    }
}

