
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "predictiveModelQualities",
    "clusteringModelQualities",
    "correlations"
})
@XmlRootElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_3")
@Added((org.dmg.pmml.Version.PMML_4_0))
public class ModelExplanation
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ModelExplanation>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "PredictiveModelQuality", namespace = "http://www.dmg.org/PMML-4_3")
    private List<PredictiveModelQuality> predictiveModelQualities;
    @XmlElement(name = "ClusteringModelQuality", namespace = "http://www.dmg.org/PMML-4_3")
    private List<ClusteringModelQuality> clusteringModelQualities;
    @XmlElement(name = "Correlations", namespace = "http://www.dmg.org/PMML-4_3")
    private Correlations correlations;
    private final static long serialVersionUID = 67305481L;

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<PredictiveModelQuality> getPredictiveModelQualities() {
        if (predictiveModelQualities == null) {
            predictiveModelQualities = new ArrayList<PredictiveModelQuality>();
        }
        return this.predictiveModelQualities;
    }

    public List<ClusteringModelQuality> getClusteringModelQualities() {
        if (clusteringModelQualities == null) {
            clusteringModelQualities = new ArrayList<ClusteringModelQuality>();
        }
        return this.clusteringModelQualities;
    }

    public Correlations getCorrelations() {
        return correlations;
    }

    public ModelExplanation setCorrelations(
        @Property("correlations")
        Correlations correlations) {
        this.correlations = correlations;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public ModelExplanation addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasPredictiveModelQualities() {
        return ((this.predictiveModelQualities!= null)&&(this.predictiveModelQualities.size()> 0));
    }

    public ModelExplanation addPredictiveModelQualities(PredictiveModelQuality... predictiveModelQualities) {
        getPredictiveModelQualities().addAll(Arrays.asList(predictiveModelQualities));
        return this;
    }

    public boolean hasClusteringModelQualities() {
        return ((this.clusteringModelQualities!= null)&&(this.clusteringModelQualities.size()> 0));
    }

    public ModelExplanation addClusteringModelQualities(ClusteringModelQuality... clusteringModelQualities) {
        getClusteringModelQualities().addAll(Arrays.asList(clusteringModelQualities));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasPredictiveModelQualities()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getPredictiveModelQualities());
            }
            if ((status == VisitorAction.CONTINUE)&&hasClusteringModelQualities()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getClusteringModelQualities());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getCorrelations());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
