
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "ScoreDistribution", namespace = "http://www.dmg.org/PMML-4_3")
public class ScoreDistribution
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ScoreDistribution>
{

    @XmlAttribute(name = "value", required = true)
    private String value;
    @XmlAttribute(name = "recordCount", required = true)
    private double recordCount;
    @XmlAttribute(name = "confidence")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private Double confidence;
    @XmlAttribute(name = "probability")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    private Double probability;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305481L;

    public ScoreDistribution() {
    }

    public ScoreDistribution(
        @org.jpmml.model.annotations.Property("value")
        String value,
        @org.jpmml.model.annotations.Property("recordCount")
        double recordCount) {
        this.value = value;
        this.recordCount = recordCount;
    }

    public String getValue() {
        return value;
    }

    public ScoreDistribution setValue(
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.value = value;
        return this;
    }

    public double getRecordCount() {
        return recordCount;
    }

    public ScoreDistribution setRecordCount(
        @org.jpmml.model.annotations.Property("recordCount")
        double recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    public Double getConfidence() {
        return confidence;
    }

    public ScoreDistribution setConfidence(
        @org.jpmml.model.annotations.Property("confidence")
        Double confidence) {
        this.confidence = confidence;
        return this;
    }

    public Double getProbability() {
        return probability;
    }

    public ScoreDistribution setProbability(
        @org.jpmml.model.annotations.Property("probability")
        Double probability) {
        this.probability = probability;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public ScoreDistribution addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
