
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions"
})
@XmlRootElement(name = "SimplePredicate", namespace = "http://www.dmg.org/PMML-4_3")
public class SimplePredicate
    extends Predicate
    implements HasExtensions<SimplePredicate> , HasFieldReference<SimplePredicate> , HasValue<SimplePredicate>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name = "operator", required = true)
    private SimplePredicate.Operator operator;
    @XmlAttribute(name = "value")
    private String value;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67305481L;

    public SimplePredicate() {
    }

    public SimplePredicate(
        @org.jpmml.model.annotations.Property("field")
        FieldName field,
        @org.jpmml.model.annotations.Property("operator")
        SimplePredicate.Operator operator) {
        this.field = field;
        this.operator = operator;
    }

    public FieldName getField() {
        return field;
    }

    public SimplePredicate setField(
        @org.jpmml.model.annotations.Property("field")
        FieldName field) {
        this.field = field;
        return this;
    }

    public SimplePredicate.Operator getOperator() {
        return operator;
    }

    public SimplePredicate setOperator(
        @org.jpmml.model.annotations.Property("operator")
        SimplePredicate.Operator operator) {
        this.operator = operator;
        return this;
    }

    public String getValue() {
        return value;
    }

    public SimplePredicate setValue(
        @org.jpmml.model.annotations.Property("value")
        String value) {
        this.value = value;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public SimplePredicate addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Operator {

        @XmlEnumValue("equal")
        EQUAL("equal"),
        @XmlEnumValue("notEqual")
        NOT_EQUAL("notEqual"),
        @XmlEnumValue("lessThan")
        LESS_THAN("lessThan"),
        @XmlEnumValue("lessOrEqual")
        LESS_OR_EQUAL("lessOrEqual"),
        @XmlEnumValue("greaterThan")
        GREATER_THAN("greaterThan"),
        @XmlEnumValue("greaterOrEqual")
        GREATER_OR_EQUAL("greaterOrEqual"),
        @XmlEnumValue("isMissing")
        IS_MISSING("isMissing"),
        @XmlEnumValue("isNotMissing")
        IS_NOT_MISSING("isNotMissing");
        private final String value;

        Operator(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static SimplePredicate.Operator fromValue(String v) {
            for (SimplePredicate.Operator c: SimplePredicate.Operator.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
