
package org.dmg.pmml.naive_bayes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "targetValueCounts"
})
@XmlRootElement(name = "TargetValueCounts", namespace = "http://www.dmg.org/PMML-4_3")
public class TargetValueCounts
    extends org.dmg.pmml.PMMLObject
    implements Iterable<TargetValueCount> , HasExtensions<TargetValueCounts>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "TargetValueCount", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<TargetValueCount> targetValueCounts;
    private final static long serialVersionUID = 67305481L;

    public TargetValueCounts() {
    }

    public TargetValueCounts(
        @Property("targetValueCounts")
        List<TargetValueCount> targetValueCounts) {
        this.targetValueCounts = targetValueCounts;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<TargetValueCount> getTargetValueCounts() {
        if (targetValueCounts == null) {
            targetValueCounts = new ArrayList<TargetValueCount>();
        }
        return this.targetValueCounts;
    }

    public Iterator<TargetValueCount> iterator() {
        return getTargetValueCounts().iterator();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public TargetValueCounts addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasTargetValueCounts() {
        return ((this.targetValueCounts!= null)&&(this.targetValueCounts.size()> 0));
    }

    public TargetValueCounts addTargetValueCounts(TargetValueCount... targetValueCounts) {
        getTargetValueCounts().addAll(Arrays.asList(targetValueCounts));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTargetValueCounts()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTargetValueCounts());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
