
package org.dmg.pmml.scorecard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.Extension;
import org.dmg.pmml.False;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasPredicate;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.Property;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "predicate",
    "complexPartialScore"
})
@XmlRootElement(name = "Attribute", namespace = "http://www.dmg.org/PMML-4_3")
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
public class Attribute
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Attribute> , HasPredicate<Attribute>
{

    @XmlAttribute(name = "reasonCode")
    private String reasonCode;
    @XmlAttribute(name = "partialScore")
    @Optional((org.dmg.pmml.Version.PMML_4_2))
    private Double partialScore;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "SimplePredicate", namespace = "http://www.dmg.org/PMML-4_3", type = SimplePredicate.class),
        @XmlElement(name = "CompoundPredicate", namespace = "http://www.dmg.org/PMML-4_3", type = CompoundPredicate.class),
        @XmlElement(name = "SimpleSetPredicate", namespace = "http://www.dmg.org/PMML-4_3", type = SimpleSetPredicate.class),
        @XmlElement(name = "True", namespace = "http://www.dmg.org/PMML-4_3", type = True.class),
        @XmlElement(name = "False", namespace = "http://www.dmg.org/PMML-4_3", type = False.class)
    })
    private Predicate predicate;
    @XmlElement(name = "ComplexPartialScore", namespace = "http://www.dmg.org/PMML-4_3")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    private ComplexPartialScore complexPartialScore;
    private final static long serialVersionUID = 67305481L;

    public String getReasonCode() {
        return reasonCode;
    }

    public Attribute setReasonCode(
        @Property("reasonCode")
        String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    public Double getPartialScore() {
        return partialScore;
    }

    public Attribute setPartialScore(
        @Property("partialScore")
        Double partialScore) {
        this.partialScore = partialScore;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public Predicate getPredicate() {
        return predicate;
    }

    public Attribute setPredicate(
        @Property("predicate")
        Predicate predicate) {
        this.predicate = predicate;
        return this;
    }

    public ComplexPartialScore getComplexPartialScore() {
        return complexPartialScore;
    }

    public Attribute setComplexPartialScore(
        @Property("complexPartialScore")
        ComplexPartialScore complexPartialScore) {
        this.complexPartialScore = complexPartialScore;
        return this;
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Attribute addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getPredicate(), getComplexPartialScore());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
