
package org.dmg.pmml.support_vector_machine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "extensions",
    "coefficients"
})
@XmlRootElement(name = "Coefficients", namespace = "http://www.dmg.org/PMML-4_3")
public class Coefficients
    extends org.dmg.pmml.PMMLObject
    implements Iterable<Coefficient> , HasExtensions<Coefficients>
{

    @XmlAttribute(name = "numberOfCoefficients")
    private Integer numberOfCoefficients;
    @XmlAttribute(name = "absoluteValue")
    private Double absoluteValue;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;
    @XmlElement(name = "Coefficient", namespace = "http://www.dmg.org/PMML-4_3", required = true)
    private List<Coefficient> coefficients;
    private final static Double DEFAULT_ABSOLUTE_VALUE = 0.0D;
    private final static long serialVersionUID = 67305481L;

    public Coefficients() {
    }

    public Coefficients(
        @org.jpmml.model.annotations.Property("coefficients")
        List<Coefficient> coefficients) {
        this.coefficients = coefficients;
    }

    public Integer getNumberOfCoefficients() {
        return numberOfCoefficients;
    }

    public Coefficients setNumberOfCoefficients(
        @org.jpmml.model.annotations.Property("numberOfCoefficients")
        Integer numberOfCoefficients) {
        this.numberOfCoefficients = numberOfCoefficients;
        return this;
    }

    public Double getAbsoluteValue() {
        if (absoluteValue == null) {
            return DEFAULT_ABSOLUTE_VALUE;
        } else {
            return absoluteValue;
        }
    }

    public Coefficients setAbsoluteValue(
        @org.jpmml.model.annotations.Property("absoluteValue")
        Double absoluteValue) {
        this.absoluteValue = absoluteValue;
        return this;
    }

    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<Coefficient> getCoefficients() {
        if (coefficients == null) {
            coefficients = new ArrayList<Coefficient>();
        }
        return this.coefficients;
    }

    public Iterator<Coefficient> iterator() {
        return getCoefficients().iterator();
    }

    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(this.extensions.size()> 0));
    }

    public Coefficients addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasCoefficients() {
        return ((this.coefficients!= null)&&(this.coefficients.size()> 0));
    }

    public Coefficients addCoefficients(Coefficient... coefficients) {
        getCoefficients().addAll(Arrays.asList(coefficients));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasCoefficients()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getCoefficients());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
