/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jupnp.QueueingThreadPoolExecutor;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.binding.xml.DeviceDescriptorBinder;
import org.jupnp.binding.xml.RecoveringUDA10DeviceDescriptorBinderImpl;
import org.jupnp.binding.xml.RecoveringUDA10ServiceDescriptorBinderSAXImpl;
import org.jupnp.binding.xml.ServiceDescriptorBinder;
import org.jupnp.model.ModelUtil;
import org.jupnp.model.Namespace;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.model.types.ServiceType;
import org.jupnp.transport.impl.DatagramIOConfigurationImpl;
import org.jupnp.transport.impl.DatagramIOImpl;
import org.jupnp.transport.impl.DatagramProcessorImpl;
import org.jupnp.transport.impl.GENAEventProcessorImpl;
import org.jupnp.transport.impl.MulticastReceiverConfigurationImpl;
import org.jupnp.transport.impl.MulticastReceiverImpl;
import org.jupnp.transport.impl.NetworkAddressFactoryImpl;
import org.jupnp.transport.impl.SOAPActionProcessorImpl;
import org.jupnp.transport.impl.ServletStreamServerConfigurationImpl;
import org.jupnp.transport.impl.ServletStreamServerImpl;
import org.jupnp.transport.impl.StreamServerConfigurationImpl;
import org.jupnp.transport.impl.StreamServerImpl;
import org.jupnp.transport.impl.jetty.JettyStreamClientImpl;
import org.jupnp.transport.impl.jetty.StreamClientConfigurationImpl;
import org.jupnp.transport.impl.osgi.HttpServiceServletContainerAdapter;
import org.jupnp.transport.spi.DatagramIO;
import org.jupnp.transport.spi.DatagramProcessor;
import org.jupnp.transport.spi.GENAEventProcessor;
import org.jupnp.transport.spi.MulticastReceiver;
import org.jupnp.transport.spi.NetworkAddressFactory;
import org.jupnp.transport.spi.SOAPActionProcessor;
import org.jupnp.transport.spi.StreamClient;
import org.jupnp.transport.spi.StreamServer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSGiUpnpServiceConfiguration
implements UpnpServiceConfiguration {
    private static final String OSGI_SERVICE_HTTP_PORT = "org.osgi.service.http.port";
    private Logger log = LoggerFactory.getLogger(OSGiUpnpServiceConfiguration.class);
    private int threadPoolSize = 20;
    private int asyncThreadPoolSize = 20;
    private int multicastResponsePort;
    private int httpProxyPort = -1;
    private int streamListenPort = 8080;
    private Namespace callbackURI = new Namespace("http://localhost/upnpcallback");
    private ExecutorService mainExecutorService;
    private ExecutorService asyncExecutorService;
    private DatagramProcessor datagramProcessor;
    private SOAPActionProcessor soapActionProcessor;
    private GENAEventProcessor genaEventProcessor;
    private DeviceDescriptorBinder deviceDescriptorBinderUDA10;
    private ServiceDescriptorBinder serviceDescriptorBinderUDA10;
    private Namespace namespace;
    private BundleContext context;
    private ServiceRegistration serviceReg;
    private ServiceReference httpServiceReference;

    public OSGiUpnpServiceConfiguration() {
        this(0);
    }

    public OSGiUpnpServiceConfiguration(int streamListenPort) {
        this(streamListenPort, 0, true);
    }

    public OSGiUpnpServiceConfiguration(int streamListenPort, int multicastResponsePort) {
        this(streamListenPort, multicastResponsePort, true);
    }

    protected OSGiUpnpServiceConfiguration(boolean checkRuntime) {
        this(0, 0, checkRuntime);
    }

    protected OSGiUpnpServiceConfiguration(int streamListenPort, int multicastResponsePort, boolean checkRuntime) {
        if (checkRuntime && ModelUtil.ANDROID_RUNTIME) {
            throw new Error("Unsupported runtime environment, use org.jupnp.android.AndroidUpnpServiceConfiguration");
        }
        this.streamListenPort = streamListenPort;
        this.multicastResponsePort = multicastResponsePort;
    }

    protected void activate(BundleContext context, Map<String, Object> configProps) throws ConfigurationException {
        this.context = context;
        this.createConfiguration(configProps);
        this.createExecutorServices();
        this.datagramProcessor = this.createDatagramProcessor();
        this.soapActionProcessor = this.createSOAPActionProcessor();
        this.genaEventProcessor = this.createGENAEventProcessor();
        this.deviceDescriptorBinderUDA10 = this.createDeviceDescriptorBinderUDA10();
        this.serviceDescriptorBinderUDA10 = this.createServiceDescriptorBinderUDA10();
        this.namespace = this.createNamespace();
    }

    protected void deactivate() {
        if (this.serviceReg != null) {
            this.serviceReg.unregister();
        }
        if (this.httpServiceReference != null) {
            this.context.ungetService(this.httpServiceReference);
        }
        this.shutdown();
    }

    @Override
    public DatagramProcessor getDatagramProcessor() {
        return this.datagramProcessor;
    }

    @Override
    public SOAPActionProcessor getSoapActionProcessor() {
        return this.soapActionProcessor;
    }

    @Override
    public GENAEventProcessor getGenaEventProcessor() {
        return this.genaEventProcessor;
    }

    @Override
    public StreamClient createStreamClient() {
        return new JettyStreamClientImpl(new StreamClientConfigurationImpl(this.getSyncProtocolExecutorService()));
    }

    @Override
    public MulticastReceiver createMulticastReceiver(NetworkAddressFactory networkAddressFactory) {
        return new MulticastReceiverImpl(new MulticastReceiverConfigurationImpl(networkAddressFactory.getMulticastGroup(), networkAddressFactory.getMulticastPort()));
    }

    @Override
    public DatagramIO createDatagramIO(NetworkAddressFactory networkAddressFactory) {
        return new DatagramIOImpl(new DatagramIOConfigurationImpl());
    }

    @Override
    public StreamServer createStreamServer(NetworkAddressFactory networkAddressFactory) {
        ServiceReference serviceReference = this.context.getServiceReference(HttpService.class.getName());
        if (serviceReference != null) {
            if (this.httpServiceReference != null) {
                this.context.ungetService(this.httpServiceReference);
            }
            this.httpServiceReference = serviceReference;
            HttpService httpService = (HttpService)this.context.getService(serviceReference);
            if (httpService != null) {
                return new ServletStreamServerImpl(new ServletStreamServerConfigurationImpl(HttpServiceServletContainerAdapter.getInstance(httpService, this.context), this.httpProxyPort != -1 ? this.httpProxyPort : this.callbackURI.getBasePath().getPort()));
            }
        }
        return new StreamServerImpl(new StreamServerConfigurationImpl());
    }

    @Override
    public ExecutorService getMulticastReceiverExecutor() {
        return this.getMainExecutorService();
    }

    @Override
    public ExecutorService getDatagramIOExecutor() {
        return this.getMainExecutorService();
    }

    @Override
    public ExecutorService getStreamServerExecutorService() {
        return this.getMainExecutorService();
    }

    @Override
    public DeviceDescriptorBinder getDeviceDescriptorBinderUDA10() {
        return this.deviceDescriptorBinderUDA10;
    }

    @Override
    public ServiceDescriptorBinder getServiceDescriptorBinderUDA10() {
        return this.serviceDescriptorBinderUDA10;
    }

    @Override
    public ServiceType[] getExclusiveServiceTypes() {
        return new ServiceType[0];
    }

    @Override
    public boolean isReceivedSubscriptionTimeoutIgnored() {
        return false;
    }

    @Override
    public UpnpHeaders getDescriptorRetrievalHeaders(RemoteDeviceIdentity identity) {
        return null;
    }

    @Override
    public UpnpHeaders getEventSubscriptionHeaders(RemoteService service) {
        return null;
    }

    @Override
    public int getRegistryMaintenanceIntervalMillis() {
        return 1000;
    }

    @Override
    public int getAliveIntervalMillis() {
        return 0;
    }

    @Override
    public Integer getRemoteDeviceMaxAgeSeconds() {
        return null;
    }

    @Override
    public ExecutorService getAsyncProtocolExecutor() {
        return this.asyncExecutorService;
    }

    @Override
    public ExecutorService getSyncProtocolExecutorService() {
        return this.getMainExecutorService();
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Executor getRegistryMaintainerExecutor() {
        return this.getMainExecutorService();
    }

    @Override
    public Executor getRegistryListenerExecutor() {
        return this.getMainExecutorService();
    }

    @Override
    public NetworkAddressFactory createNetworkAddressFactory() {
        return this.createNetworkAddressFactory(this.streamListenPort, this.multicastResponsePort);
    }

    @Override
    public void shutdown() {
        this.log.debug("Shutting down executor services");
        this.shutdownExecutorServices();
        this.createExecutorServices();
    }

    protected void shutdownExecutorServices() {
        if (this.mainExecutorService != null) {
            this.mainExecutorService.shutdownNow();
        }
        if (this.asyncExecutorService != null) {
            this.asyncExecutorService.shutdownNow();
        }
    }

    protected NetworkAddressFactory createNetworkAddressFactory(int streamListenPort, int multicastResponsePort) {
        return new NetworkAddressFactoryImpl(streamListenPort, multicastResponsePort);
    }

    protected DatagramProcessor createDatagramProcessor() {
        return new DatagramProcessorImpl();
    }

    protected SOAPActionProcessor createSOAPActionProcessor() {
        return new SOAPActionProcessorImpl();
    }

    protected GENAEventProcessor createGENAEventProcessor() {
        return new GENAEventProcessorImpl();
    }

    protected DeviceDescriptorBinder createDeviceDescriptorBinderUDA10() {
        return new RecoveringUDA10DeviceDescriptorBinderImpl();
    }

    protected ServiceDescriptorBinder createServiceDescriptorBinderUDA10() {
        return new RecoveringUDA10ServiceDescriptorBinderSAXImpl();
    }

    protected Namespace createNamespace() {
        return this.callbackURI;
    }

    protected ExecutorService getMainExecutorService() {
        return this.mainExecutorService;
    }

    private void createExecutorServices() {
        this.mainExecutorService = this.createMainExecutorService();
        this.asyncExecutorService = this.createAsyncProtocolExecutorService();
    }

    protected ExecutorService createMainExecutorService() {
        return QueueingThreadPoolExecutor.createInstance("upnp-main", this.threadPoolSize);
    }

    private ExecutorService createAsyncProtocolExecutorService() {
        return QueueingThreadPoolExecutor.createInstance("upnp-async", this.asyncThreadPoolSize);
    }

    private void createConfiguration(Map<String, Object> properties) throws ConfigurationException {
        if (properties == null) {
            return;
        }
        Object prop = properties.get("threadPoolSize");
        if (prop instanceof String) {
            try {
                this.threadPoolSize = Integer.valueOf((String)prop);
            }
            catch (NumberFormatException numberFormatException) {
                this.log.error("Invalid value '{}' for threadPoolSize - using default value '{}'", prop, (Object)this.threadPoolSize);
            }
        } else if (prop instanceof Integer) {
            this.threadPoolSize = (Integer)prop;
        }
        if ((prop = properties.get("asyncThreadPoolSize")) instanceof String) {
            try {
                this.asyncThreadPoolSize = Integer.valueOf((String)prop);
            }
            catch (NumberFormatException numberFormatException) {
                this.log.error("Invalid value '{}' for asyncThreadPoolSize - using default value '{}'", prop, (Object)this.asyncThreadPoolSize);
            }
        } else if (prop instanceof Integer) {
            this.asyncThreadPoolSize = (Integer)prop;
        }
        if ((prop = properties.get("multicastResponsePort")) instanceof String) {
            try {
                this.multicastResponsePort = Integer.valueOf((String)prop);
            }
            catch (NumberFormatException numberFormatException) {
                this.log.error("Invalid value '{}' for multicastResponsePort - using default value '{}'", prop, (Object)this.multicastResponsePort);
            }
        } else if (prop instanceof Integer) {
            this.multicastResponsePort = (Integer)prop;
        }
        if ((prop = properties.get("streamListenPort")) instanceof String) {
            try {
                this.streamListenPort = Integer.valueOf((String)prop);
            }
            catch (NumberFormatException numberFormatException) {
                this.log.error("Invalid value '{}' for streamListenPort - using default value '{}'", prop, (Object)this.streamListenPort);
            }
        } else if (prop instanceof Integer) {
            this.streamListenPort = (Integer)prop;
        } else if (System.getProperty(OSGI_SERVICE_HTTP_PORT) != null) {
            try {
                this.streamListenPort = Integer.valueOf(System.getProperty(OSGI_SERVICE_HTTP_PORT));
            }
            catch (NumberFormatException numberFormatException) {
                this.log.debug("Invalid value '{}' for osgi.http.port - using default value '{}'", prop, (Object)this.streamListenPort);
            }
        }
        prop = properties.get("callbackURI");
        if (prop instanceof String) {
            try {
                this.callbackURI = new Namespace((String)prop);
            }
            catch (Exception exception) {
                this.log.error("Invalid value '{}' for callbackURI - using default value '{}'", prop, (Object)this.callbackURI);
            }
        }
        if ((prop = properties.get("httpProxyPort")) instanceof String) {
            try {
                this.httpProxyPort = Integer.valueOf((String)prop);
            }
            catch (NumberFormatException numberFormatException) {
                this.log.error("Invalid value '{}' for httpProxyPort - using default value '{}'", prop, (Object)this.httpProxyPort);
            }
        } else if (prop instanceof Integer) {
            this.httpProxyPort = (Integer)prop;
        }
    }
}

