/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueingThreadPoolExecutor
extends ThreadPoolExecutor {
    private Logger logger = LoggerFactory.getLogger(QueueingThreadPoolExecutor.class);
    static final int CORE_THREAD_POOL_SIZE = 1;
    private LinkedTransferQueue<Runnable> taskQueue = new LinkedTransferQueue();
    private Thread queueThread;
    private final Object semaphore = new Object();
    private final String threadPoolName;

    protected QueueingThreadPoolExecutor(String name, int threadPoolSize) {
        this(name, new CommonThreadFactory(name), threadPoolSize, new QueueingRejectionHandler());
    }

    private QueueingThreadPoolExecutor(String threadPoolName, ThreadFactory threadFactory, int threadPoolSize, RejectedExecutionHandler rejectionHandler) {
        super(1, threadPoolSize, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, rejectionHandler);
        this.threadPoolName = threadPoolName;
        this.allowCoreThreadTimeOut(true);
    }

    public static QueueingThreadPoolExecutor createInstance(String name, int threadPoolSize) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("A thread pool name must be provided!");
        }
        return new QueueingThreadPoolExecutor(name, new CommonThreadFactory(name), threadPoolSize, new QueueingRejectionHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToQueue(Runnable runnable) {
        this.taskQueue.add(runnable);
        if (this.queueThread == null || !this.queueThread.isAlive()) {
            QueueingThreadPoolExecutor queueingThreadPoolExecutor = this;
            synchronized (queueingThreadPoolExecutor) {
                if (this.queueThread == null || !this.queueThread.isAlive()) {
                    this.logger.warn("Thread pool '{}' exhausted, queueing tasks now.", (Object)this.threadPoolName);
                    this.queueThread = this.createNewQueueThread();
                    this.queueThread.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        Object object = this.semaphore;
        synchronized (object) {
            this.semaphore.notify();
        }
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        return this.taskQueue;
    }

    @Override
    public void execute(Runnable command) {
        if (this.taskQueue.isEmpty()) {
            super.execute(command);
        } else {
            if (command == null) {
                throw new NullPointerException();
            }
            if (!this.isShutdown()) {
                this.addToQueue(command);
            }
        }
    }

    private Thread createNewQueueThread() {
        Thread thread = this.getThreadFactory().newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    if (QueueingThreadPoolExecutor.this.getActiveCount() < QueueingThreadPoolExecutor.this.getMaximumPoolSize()) {
                        try {
                            Runnable runnable = (Runnable)QueueingThreadPoolExecutor.this.taskQueue.poll(2L, TimeUnit.SECONDS);
                            if (runnable == null) break;
                            QueueingThreadPoolExecutor.this.logger.debug("Executing queued task of thread pool '{}'.", (Object)QueueingThreadPoolExecutor.this.threadPoolName);
                            QueueingThreadPoolExecutor.super.execute(runnable);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    try {
                        Object object = QueueingThreadPoolExecutor.this.semaphore;
                        synchronized (object) {
                            QueueingThreadPoolExecutor.this.semaphore.wait(1000L);
                            continue;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                QueueingThreadPoolExecutor.this.logger.debug("Queue for thread pool '{}' fully processed - terminating queue thread.", (Object)QueueingThreadPoolExecutor.this.threadPoolName);
            }
        });
        thread.setName(String.valueOf(this.threadPoolName) + "-queue");
        return thread;
    }

    private static class CommonThreadFactory
    implements ThreadFactory {
        protected final ThreadGroup group;
        protected final AtomicInteger threadNumber = new AtomicInteger(1);
        protected final String name;

        public CommonThreadFactory(String name) {
            this.name = name;
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, String.valueOf(this.name) + "-" + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private static class QueueingRejectionHandler
    extends ThreadPoolExecutor.DiscardPolicy {
        private QueueingRejectionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            if (!threadPoolExecutor.isShutdown()) {
                QueueingThreadPoolExecutor queueingThreadPoolExecutor = (QueueingThreadPoolExecutor)threadPoolExecutor;
                queueingThreadPoolExecutor.addToQueue(runnable);
            }
        }
    }
}

