/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jupnp.OSGiUpnpServiceConfiguration;
import org.jupnp.UpnpService;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.controlpoint.ControlPoint;
import org.jupnp.controlpoint.ControlPointImpl;
import org.jupnp.model.message.header.STAllHeader;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.protocol.ProtocolFactoryImpl;
import org.jupnp.registry.Registry;
import org.jupnp.registry.RegistryImpl;
import org.jupnp.transport.Router;
import org.jupnp.transport.RouterException;
import org.jupnp.transport.RouterImpl;
import org.jupnp.util.Exceptions;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpnpServiceImpl
implements UpnpService {
    private final Logger log = LoggerFactory.getLogger(UpnpServiceImpl.class);
    protected boolean isConfigured = false;
    protected Boolean isRunning = false;
    private final Object lock = new Object();
    protected UpnpServiceConfiguration configuration;
    protected ProtocolFactory protocolFactory;
    protected Registry registry;
    protected ControlPoint controlPoint;
    protected Router router;
    protected ScheduledExecutorService scheduledExecutorService;
    protected volatile ScheduledFuture<?> scheduledFuture;

    public UpnpServiceImpl() {
    }

    public UpnpServiceImpl(UpnpServiceConfiguration configuration) {
        this.configuration = configuration;
    }

    private static ScheduledExecutorService createExecutor() {
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "Upnp Service Delayed Startup Thread");
                thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread thread, Throwable exception) {
                        throw new IllegalStateException(exception);
                    }
                });
                return thread;
            }
        });
    }

    protected void setOSGiUpnpServiceConfiguration(OSGiUpnpServiceConfiguration configuration) {
        this.configuration = configuration;
        if (this.isRunning.booleanValue()) {
            this.restart(true);
        }
    }

    protected void unsetOSGiUpnpServiceConfiguration(OSGiUpnpServiceConfiguration configuration) {
        this.configuration = null;
    }

    protected void setHttpService(HttpService httpService) {
        if (this.isRunning.booleanValue()) {
            this.shutdown(false);
            this.delayedStartup(1500);
        }
    }

    protected void unsetHttpService(HttpService httpService) {
        if (this.isRunning.booleanValue()) {
            this.shutdown(false);
            this.delayedStartup(1500);
        }
    }

    protected ProtocolFactory createProtocolFactory() {
        return new ProtocolFactoryImpl(this);
    }

    protected Registry createRegistry(ProtocolFactory protocolFactory) {
        return new RegistryImpl(this);
    }

    protected Router createRouter(ProtocolFactory protocolFactory, Registry registry) {
        return new RouterImpl(this.getConfiguration(), protocolFactory);
    }

    protected ControlPoint createControlPoint(ProtocolFactory protocolFactory, Registry registry) {
        return new ControlPointImpl(this.getConfiguration(), protocolFactory, registry);
    }

    @Override
    public UpnpServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    @Override
    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public Router getRouter() {
        return this.router;
    }

    @Override
    public synchronized void shutdown() {
        this.shutdown(false);
    }

    protected void shutdown(boolean separateThread) {
        Runnable shutdown = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = UpnpServiceImpl.this.lock;
                synchronized (object) {
                    if (UpnpServiceImpl.this.isRunning.booleanValue()) {
                        UpnpServiceImpl.this.log.info("Shutting down UPnP service...");
                        UpnpServiceImpl.this.shutdownRegistry();
                        UpnpServiceImpl.this.shutdownConfiguration();
                        UpnpServiceImpl.this.shutdownRouter();
                        UpnpServiceImpl.this.log.info("UPnP service shutdown completed");
                        UpnpServiceImpl.this.isRunning = false;
                    }
                }
            }
        };
        if (separateThread) {
            new Thread(shutdown).start();
        } else {
            shutdown.run();
        }
    }

    private void restart(boolean separateThread) {
        Runnable restart = new Runnable(){

            @Override
            public void run() {
                UpnpServiceImpl.this.shutdown();
                UpnpServiceImpl.this.startup();
            }
        };
        if (separateThread) {
            new Thread(restart).start();
        } else {
            restart.run();
        }
    }

    protected void shutdownRegistry() {
        this.getRegistry().shutdown();
    }

    protected void shutdownRouter() {
        try {
            this.getRouter().shutdown();
        }
        catch (RouterException ex) {
            Throwable cause = Exceptions.unwrap(ex);
            if (cause instanceof InterruptedException) {
                this.log.debug("Router shutdown was interrupted: " + ex, cause);
            }
            throw new RuntimeException("Router error on shutdown: " + ex, ex);
        }
    }

    protected void shutdownConfiguration() {
        this.getConfiguration().shutdown();
    }

    private void delayedStartup(int msDelay) {
        Runnable startup = new Runnable(){

            @Override
            public void run() {
                UpnpServiceImpl.this.startup();
            }
        };
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        this.scheduledFuture = this.scheduledExecutorService.schedule(startup, (long)msDelay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isRunning.booleanValue()) {
                this.log.info("Starting UPnP service...");
                this.log.debug("Using configuration: " + this.getConfiguration().getClass().getName());
                this.protocolFactory = this.createProtocolFactory();
                this.registry = this.createRegistry(this.protocolFactory);
                this.router = this.createRouter(this.protocolFactory, this.registry);
                try {
                    this.router.enable();
                }
                catch (RouterException ex) {
                    throw new RuntimeException("Enabling network router failed: " + ex, ex);
                }
                this.controlPoint = this.createControlPoint(this.protocolFactory, this.registry);
                this.log.debug("UPnP service started successfully");
                this.isRunning = true;
                this.controlPoint.search(new STAllHeader());
            }
        }
    }

    protected void activate() {
        this.scheduledFuture = null;
        this.scheduledExecutorService = UpnpServiceImpl.createExecutor();
        this.startup();
    }

    protected void deactivate() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
        this.scheduledExecutorService.shutdownNow();
        this.shutdown();
    }
}

