/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.http;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Query {
    protected final Map<String, List<String>> parameters = new LinkedHashMap<String, List<String>>();

    public static Query newInstance(Map<String, List<String>> parameters) {
        Query query = new Query();
        query.parameters.putAll(parameters);
        return query;
    }

    public Query() {
    }

    public Query(Map<String, String[]> parameters) {
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            List<String> list = Arrays.asList(entry.getValue() != null ? entry.getValue() : new String[]{});
            this.parameters.put(entry.getKey(), list);
        }
    }

    public Query(URL url) {
        this(url.getQuery());
    }

    public Query(String qs) {
        String[] pairs;
        if (qs == null) {
            return;
        }
        String[] stringArray = pairs = qs.split("&");
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            String name;
            String pair = stringArray[n2];
            int pos = pair.indexOf(61);
            if (pos == -1) {
                name = pair;
                value = null;
            } else {
                try {
                    name = URLDecoder.decode(pair.substring(0, pos), "UTF-8");
                    value = URLDecoder.decode(pair.substring(pos + 1, pair.length()), "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new IllegalStateException("Query string is not UTF-8");
                }
            }
            List<String> list = this.parameters.get(name);
            if (list == null) {
                list = new ArrayList<String>();
                this.parameters.put(name, list);
            }
            list.add(value);
            ++n2;
        }
    }

    public String get(String name) {
        List<String> values = this.parameters.get(name);
        if (values == null) {
            return "";
        }
        if (values.size() == 0) {
            return "";
        }
        return values.get(0);
    }

    public String[] getValues(String name) {
        List<String> values = this.parameters.get(name);
        if (values == null) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    public List<String> getValuesAsList(String name) {
        return this.parameters.containsKey(name) ? Collections.unmodifiableList(this.parameters.get(name)) : null;
    }

    public Enumeration<String> getNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public Map<String, String[]> getMap() {
        TreeMap<String, String[]> map = new TreeMap<String, String[]>();
        for (Map.Entry<String, List<String>> entry : this.parameters.entrySet()) {
            List<String> list = entry.getValue();
            String[] values = list == null ? null : list.toArray(new String[list.size()]);
            map.put(entry.getKey(), values);
        }
        return map;
    }

    public Map<String, List<String>> getMapWithLists() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public boolean isEmpty() {
        return this.parameters.size() == 0;
    }

    public Query cloneAndAdd(String name, String ... values) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>(this.getMapWithLists());
        ArrayList<String> existingValues = (ArrayList<String>)params.get(name);
        if (existingValues == null) {
            existingValues = new ArrayList<String>();
            params.put(name, existingValues);
        }
        existingValues.addAll(Arrays.asList(values));
        return Query.newInstance(params);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.parameters.entrySet()) {
            for (String v : entry.getValue()) {
                if (v == null || v.length() == 0) continue;
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(entry.getKey());
                sb.append("=");
                sb.append(v);
            }
        }
        return sb.toString();
    }
}

