/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message.header;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jupnp.model.message.header.InvalidHeaderException;
import org.jupnp.model.message.header.UpnpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackHeader
extends UpnpHeader<List<URL>> {
    private final Logger log = LoggerFactory.getLogger(CallbackHeader.class);

    public CallbackHeader() {
        this.setValue(new ArrayList());
    }

    public CallbackHeader(List<URL> urls) {
        this();
        ((List)this.getValue()).addAll(urls);
    }

    public CallbackHeader(URL url) {
        this();
        ((List)this.getValue()).add(url);
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        if (s.length() == 0) {
            return;
        }
        if (!s.contains("<") || !s.contains(">")) {
            throw new InvalidHeaderException("URLs not in brackets: " + s);
        }
        s = s.replaceAll("<", "");
        String[] split = s.split(">");
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            String[] stringArray = split;
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    String sp = stringArray[n2];
                    if (!(sp = sp.trim()).startsWith("http://")) {
                        this.log.warn("Discarding non-http callback URL: " + sp);
                    } else {
                        URL url = new URL(sp);
                        try {
                            url.toURI();
                        }
                        catch (URISyntaxException ex) {
                            this.log.warn("Discarding callback URL, not a valid URI on this platform: " + url, (Throwable)ex);
                            break block9;
                        }
                        urls.add(url);
                    }
                }
                ++n2;
            }
            this.setValue(urls);
        }
        catch (MalformedURLException ex) {
            throw new InvalidHeaderException("Can't parse callback URLs from '" + s + "': " + ex);
        }
    }

    @Override
    public String getString() {
        StringBuilder s = new StringBuilder();
        for (URL url : (List)this.getValue()) {
            s.append("<").append(url.toString()).append(">");
        }
        return s.toString();
    }
}

