/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message.header;

import org.jupnp.model.ServerClientTokens;
import org.jupnp.model.message.header.InvalidHeaderException;
import org.jupnp.model.message.header.UpnpHeader;

public class ServerHeader
extends UpnpHeader<ServerClientTokens> {
    public ServerHeader() {
        this.setValue(new ServerClientTokens());
    }

    public ServerHeader(ServerClientTokens tokens) {
        this.setValue(tokens);
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        ServerClientTokens serverClientTokens = new ServerClientTokens();
        serverClientTokens.setOsName("UNKNOWN");
        serverClientTokens.setOsVersion("UNKNOWN");
        serverClientTokens.setProductName("UNKNOWN");
        serverClientTokens.setProductVersion("UNKNOWN");
        if (s.contains("UPnP/1.1")) {
            serverClientTokens.setMinorVersion(1);
        } else if (!s.contains("UPnP/1.")) {
            throw new InvalidHeaderException("Missing 'UPnP/1.' in server information: " + s);
        }
        try {
            String[] productNameVersion;
            String[] osNameVersion;
            int numberOfSpaces = 0;
            int i = 0;
            while (i < s.length()) {
                if (s.charAt(i) == ' ') {
                    ++numberOfSpaces;
                }
                ++i;
            }
            if (s.contains(",")) {
                String[] productTokens = s.split(",");
                osNameVersion = productTokens[0].split("/");
                productNameVersion = productTokens[2].split("/");
            } else if (numberOfSpaces > 2) {
                String beforeUpnpToken = s.substring(0, s.indexOf("UPnP/1.")).trim();
                String afterUpnpToken = s.substring(s.indexOf("UPnP/1.") + 8).trim();
                osNameVersion = beforeUpnpToken.split("/");
                productNameVersion = afterUpnpToken.split("/");
            } else {
                String[] productTokens = s.split(" ");
                osNameVersion = productTokens[0].split("/");
                productNameVersion = productTokens[2].split("/");
            }
            serverClientTokens.setOsName(osNameVersion[0].trim());
            if (osNameVersion.length > 1) {
                serverClientTokens.setOsVersion(osNameVersion[1].trim());
            }
            serverClientTokens.setProductName(productNameVersion[0].trim());
            if (productNameVersion.length > 1) {
                serverClientTokens.setProductVersion(productNameVersion[1].trim());
            }
        }
        catch (Exception exception) {
            serverClientTokens.setOsName("UNKNOWN");
            serverClientTokens.setOsVersion("UNKNOWN");
            serverClientTokens.setProductName("UNKNOWN");
            serverClientTokens.setProductVersion("UNKNOWN");
        }
        this.setValue(serverClientTokens);
    }

    @Override
    public String getString() {
        return ((ServerClientTokens)this.getValue()).getHttpToken();
    }
}

