/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jupnp.model.types.AbstractDatatype;
import org.jupnp.model.types.InvalidValueException;

public class DateTimeDatatype
extends AbstractDatatype<Calendar> {
    protected String[] readFormats;
    protected String writeFormat;

    public DateTimeDatatype(String[] readFormats, String writeFormat) {
        this.readFormats = readFormats;
        this.writeFormat = writeFormat;
    }

    @Override
    public Calendar valueOf(String s) throws InvalidValueException {
        if (s.equals("")) {
            return null;
        }
        Date d = this.getDateValue(s, this.readFormats);
        if (d == null) {
            throw new InvalidValueException("Can't parse date/time from: " + s);
        }
        Calendar c = Calendar.getInstance(this.getTimeZone());
        c.setTime(d);
        return c;
    }

    @Override
    public String getString(Calendar value) throws InvalidValueException {
        if (value == null) {
            return "";
        }
        SimpleDateFormat sdt = new SimpleDateFormat(this.writeFormat);
        sdt.setTimeZone(this.getTimeZone());
        return sdt.format(value.getTime());
    }

    protected String normalizeTimeZone(String value) {
        if (value.endsWith("Z")) {
            value = String.valueOf(value.substring(0, value.length() - 1)) + "+0000";
        } else if (value.length() > 7 && value.charAt(value.length() - 3) == ':' && (value.charAt(value.length() - 6) == '-' || value.charAt(value.length() - 6) == '+')) {
            value = String.valueOf(value.substring(0, value.length() - 3)) + value.substring(value.length() - 2);
        }
        return value;
    }

    protected Date getDateValue(String value, String[] formats) {
        value = this.normalizeTimeZone(value);
        Date d = null;
        String[] stringArray = formats;
        int n = formats.length;
        int n2 = 0;
        while (n2 < n) {
            String format = stringArray[n2];
            SimpleDateFormat sdt = new SimpleDateFormat(format);
            sdt.setTimeZone(this.getTimeZone());
            try {
                d = sdt.parse(value);
            }
            catch (ParseException parseException) {}
            ++n2;
        }
        return d;
    }

    protected TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }
}

