/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol;

import org.jupnp.UpnpService;
import org.jupnp.model.message.UpnpMessage;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.transport.RouterException;
import org.jupnp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReceivingAsync<M extends UpnpMessage>
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(UpnpService.class);
    private final UpnpService upnpService;
    private M inputMessage;

    protected ReceivingAsync(UpnpService upnpService, M inputMessage) {
        this.upnpService = upnpService;
        this.inputMessage = inputMessage;
    }

    public UpnpService getUpnpService() {
        return this.upnpService;
    }

    public M getInputMessage() {
        return this.inputMessage;
    }

    @Override
    public void run() {
        boolean proceed;
        try {
            proceed = this.waitBeforeExecution();
        }
        catch (InterruptedException interruptedException) {
            this.log.info("Protocol wait before execution interrupted (on shutdown?): " + this.getClass().getSimpleName());
            proceed = false;
        }
        if (proceed) {
            try {
                this.execute();
            }
            catch (Exception ex) {
                Throwable cause = Exceptions.unwrap(ex);
                if (cause instanceof InterruptedException) {
                    this.log.info("Interrupted protocol '" + this.getClass().getSimpleName() + "': " + ex, cause);
                }
                throw new RuntimeException("Fatal error while executing protocol '" + this.getClass().getSimpleName() + "': " + ex, ex);
            }
        }
    }

    protected boolean waitBeforeExecution() throws InterruptedException {
        return true;
    }

    protected abstract void execute() throws RouterException;

    protected <H extends UpnpHeader> H getFirstHeader(UpnpHeader.Type headerType, Class<H> subtype) {
        return ((UpnpMessage)this.getInputMessage()).getHeaders().getFirstHeader(headerType, subtype);
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ")";
    }
}

