/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.async;

import org.jupnp.UpnpService;
import org.jupnp.model.ValidationException;
import org.jupnp.model.message.IncomingDatagramMessage;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.discovery.IncomingNotificationRequest;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.protocol.ReceivingAsync;
import org.jupnp.protocol.RetrieveRemoteDescriptors;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingNotification
extends ReceivingAsync<IncomingNotificationRequest> {
    private final Logger log = LoggerFactory.getLogger(ReceivingNotification.class);

    public ReceivingNotification(UpnpService upnpService, IncomingDatagramMessage<UpnpRequest> inputMessage) {
        super(upnpService, new IncomingNotificationRequest(inputMessage));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void execute() throws RouterException {
        block12: {
            udn = ((IncomingNotificationRequest)this.getInputMessage()).getUDN();
            if (udn == null) {
                this.log.trace("Ignoring notification message without UDN: " + this.getInputMessage());
                return;
            }
            rdIdentity = new RemoteDeviceIdentity((IncomingNotificationRequest)this.getInputMessage());
            this.log.trace("Received device notification: " + rdIdentity);
            try {
                rd = new RemoteDevice(rdIdentity);
                break block12;
            }
            catch (ValidationException ex) {
                this.log.warn("Validation errors of device during discovery: " + rdIdentity);
                ** for (validationError : ex.getErrors())
            }
lbl-1000:
            // 1 sources

            {
                this.log.warn(validationError.toString());
                continue;
            }
lbl15:
            // 1 sources

            return;
        }
        if (((IncomingNotificationRequest)this.getInputMessage()).isAliveMessage()) {
            this.log.trace("Received device ALIVE advertisement, descriptor location is: " + rdIdentity.getDescriptorURL());
            if (rdIdentity.getDescriptorURL() == null) {
                this.log.trace("Ignoring message without location URL header: " + this.getInputMessage());
                return;
            }
            if (rdIdentity.getMaxAgeSeconds() == null) {
                this.log.trace("Ignoring message without max-age header: " + this.getInputMessage());
                return;
            }
            if (this.getUpnpService().getRegistry().update(rdIdentity)) {
                this.log.trace("Remote device was already known: " + udn);
                return;
            }
            this.getUpnpService().getConfiguration().getAsyncProtocolExecutor().execute(new RetrieveRemoteDescriptors(this.getUpnpService(), rd));
        } else if (((IncomingNotificationRequest)this.getInputMessage()).isByeByeMessage()) {
            this.log.trace("Received device BYEBYE advertisement");
            removed = this.getUpnpService().getRegistry().removeDevice(rd);
            if (removed) {
                this.log.trace("Removed remote device from registry: " + rd);
            }
        } else {
            this.log.trace("Ignoring unknown notification message: " + this.getInputMessage());
        }
    }
}

