/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.async;

import org.jupnp.UpnpService;
import org.jupnp.model.ValidationException;
import org.jupnp.model.message.IncomingDatagramMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.discovery.IncomingSearchResponse;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.protocol.ReceivingAsync;
import org.jupnp.protocol.RetrieveRemoteDescriptors;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingSearchResponse
extends ReceivingAsync<IncomingSearchResponse> {
    private final Logger log = LoggerFactory.getLogger(ReceivingSearchResponse.class);

    public ReceivingSearchResponse(UpnpService upnpService, IncomingDatagramMessage<UpnpResponse> inputMessage) {
        super(upnpService, new IncomingSearchResponse(inputMessage));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void execute() throws RouterException {
        block8: {
            if (!((IncomingSearchResponse)this.getInputMessage()).isSearchResponseMessage()) {
                this.log.trace("Ignoring invalid search response message: " + this.getInputMessage());
                return;
            }
            udn = ((IncomingSearchResponse)this.getInputMessage()).getRootDeviceUDN();
            if (udn == null) {
                this.log.trace("Ignoring search response message without UDN: " + this.getInputMessage());
                return;
            }
            rdIdentity = new RemoteDeviceIdentity((IncomingSearchResponse)this.getInputMessage());
            this.log.trace("Received device search response: " + rdIdentity);
            if (this.getUpnpService().getRegistry().update(rdIdentity)) {
                this.log.trace("Remote device was already known: " + udn);
                return;
            }
            try {
                rd = new RemoteDevice(rdIdentity);
                break block8;
            }
            catch (ValidationException ex) {
                this.log.warn("Validation errors of device during discovery: " + rdIdentity);
                ** for (validationError : ex.getErrors())
            }
lbl-1000:
            // 1 sources

            {
                this.log.warn(validationError.toString());
                continue;
            }
lbl21:
            // 1 sources

            return;
        }
        if (rdIdentity.getDescriptorURL() == null) {
            this.log.trace("Ignoring message without location URL header: " + this.getInputMessage());
            return;
        }
        if (rdIdentity.getMaxAgeSeconds() == null) {
            this.log.trace("Ignoring message without max-age header: " + this.getInputMessage());
            return;
        }
        this.getUpnpService().getConfiguration().getAsyncProtocolExecutor().execute(new RetrieveRemoteDescriptors(this.getUpnpService(), rd));
    }
}

