/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.sync;

import org.jupnp.UpnpService;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.model.gena.RemoteGENASubscription;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.gena.IncomingEventRequestMessage;
import org.jupnp.model.message.gena.OutgoingEventResponseMessage;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.model.resource.ServiceEventCallbackResource;
import org.jupnp.protocol.ReceivingSync;
import org.jupnp.transport.RouterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingEvent
extends ReceivingSync<StreamRequestMessage, OutgoingEventResponseMessage> {
    private final Logger log = LoggerFactory.getLogger(ReceivingEvent.class);

    public ReceivingEvent(UpnpService upnpService, StreamRequestMessage inputMessage) {
        super(upnpService, inputMessage);
    }

    @Override
    protected OutgoingEventResponseMessage executeSync() throws RouterException {
        ServiceEventCallbackResource resource;
        if (!((StreamRequestMessage)this.getInputMessage()).isContentTypeTextUDA()) {
            this.log.warn("Received without or with invalid Content-Type: " + this.getInputMessage());
        }
        if ((resource = this.getUpnpService().getRegistry().getResource(ServiceEventCallbackResource.class, ((StreamRequestMessage)this.getInputMessage()).getUri())) == null) {
            this.log.trace("No local resource found: " + this.getInputMessage());
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.NOT_FOUND));
        }
        final IncomingEventRequestMessage requestMessage = new IncomingEventRequestMessage((StreamRequestMessage)this.getInputMessage(), (RemoteService)resource.getModel());
        if (requestMessage.getSubscrptionId() == null) {
            this.log.trace("Subscription ID missing in event request: " + this.getInputMessage());
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.PRECONDITION_FAILED));
        }
        if (!requestMessage.hasValidNotificationHeaders()) {
            this.log.trace("Missing NT and/or NTS headers in event request: " + this.getInputMessage());
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.BAD_REQUEST));
        }
        if (!requestMessage.hasValidNotificationHeaders()) {
            this.log.trace("Invalid NT and/or NTS headers in event request: " + this.getInputMessage());
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.PRECONDITION_FAILED));
        }
        if (requestMessage.getSequence() == null) {
            this.log.trace("Sequence missing in event request: " + this.getInputMessage());
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.PRECONDITION_FAILED));
        }
        try {
            this.getUpnpService().getConfiguration().getGenaEventProcessor().readBody(requestMessage);
        }
        catch (UnsupportedDataException ex) {
            this.log.trace("Can't read event message request body, " + ex);
            final RemoteGENASubscription subscription = this.getUpnpService().getRegistry().getRemoteSubscription(requestMessage.getSubscrptionId());
            if (subscription != null) {
                this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        subscription.invalidMessage(ex);
                    }
                });
            }
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.INTERNAL_SERVER_ERROR));
        }
        final RemoteGENASubscription subscription = this.getUpnpService().getRegistry().getWaitRemoteSubscription(requestMessage.getSubscrptionId());
        if (subscription == null) {
            this.log.error("Invalid subscription ID, no active subscription: " + requestMessage);
            return new OutgoingEventResponseMessage(new UpnpResponse(UpnpResponse.Status.PRECONDITION_FAILED));
        }
        this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ReceivingEvent.this.log.trace("Calling active subscription with event state variable values");
                subscription.receive(requestMessage.getSequence(), requestMessage.getStateVariableValues());
            }
        });
        return new OutgoingEventResponseMessage();
    }
}

