/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.registry;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jupnp.UpnpService;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.model.DiscoveryOptions;
import org.jupnp.model.ServiceReference;
import org.jupnp.model.gena.LocalGENASubscription;
import org.jupnp.model.gena.RemoteGENASubscription;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.model.meta.Service;
import org.jupnp.model.resource.Resource;
import org.jupnp.model.types.DeviceType;
import org.jupnp.model.types.ServiceType;
import org.jupnp.model.types.UDN;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.registry.LocalItems;
import org.jupnp.registry.Registry;
import org.jupnp.registry.RegistryItem;
import org.jupnp.registry.RegistryItems;
import org.jupnp.registry.RegistryListener;
import org.jupnp.registry.RegistryMaintainer;
import org.jupnp.registry.RemoteItems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryImpl
implements Registry {
    private Logger log = LoggerFactory.getLogger(Registry.class);
    protected UpnpService upnpService;
    protected RegistryMaintainer registryMaintainer;
    protected final Set<RemoteGENASubscription> pendingSubscriptionsLock = new HashSet<RemoteGENASubscription>();
    protected Object lock = new Object();
    protected final Set<RegistryListener> registryListeners = new HashSet<RegistryListener>();
    protected final Set<RegistryItem<URI, Resource>> resourceItems = new HashSet<RegistryItem<URI, Resource>>();
    protected final List<Runnable> pendingExecutions = new ArrayList<Runnable>();
    protected final RemoteItems remoteItems = new RemoteItems(this);
    protected final LocalItems localItems = new LocalItems(this);

    public RegistryImpl() {
    }

    public RegistryImpl(UpnpService upnpService) {
        this.log.trace("Creating Registry: " + this.getClass().getName());
        this.upnpService = upnpService;
        this.log.trace("Starting registry background maintenance...");
        this.registryMaintainer = this.createRegistryMaintainer();
        if (this.registryMaintainer != null) {
            this.getConfiguration().getRegistryMaintainerExecutor().execute(this.registryMaintainer);
        }
    }

    @Override
    public UpnpService getUpnpService() {
        return this.upnpService;
    }

    @Override
    public UpnpServiceConfiguration getConfiguration() {
        return this.getUpnpService().getConfiguration();
    }

    @Override
    public ProtocolFactory getProtocolFactory() {
        return this.getUpnpService().getProtocolFactory();
    }

    protected RegistryMaintainer createRegistryMaintainer() {
        return new RegistryMaintainer(this, this.getConfiguration().getRegistryMaintenanceIntervalMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(RegistryListener listener) {
        Set<RegistryListener> set = this.registryListeners;
        synchronized (set) {
            this.registryListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(RegistryListener listener) {
        Set<RegistryListener> set = this.registryListeners;
        synchronized (set) {
            this.registryListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<RegistryListener> getListeners() {
        Set<RegistryListener> set = this.registryListeners;
        synchronized (set) {
            return Collections.unmodifiableCollection(this.registryListeners);
        }
    }

    @Override
    public boolean notifyDiscoveryStart(final RemoteDevice device) {
        if (this.getUpnpService().getRegistry().getRemoteDevice(((RemoteDeviceIdentity)device.getIdentity()).getUdn(), true) != null) {
            this.log.trace("Not notifying listeners, already registered: " + device);
            return false;
        }
        for (final RegistryListener listener : this.getListeners()) {
            this.getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    listener.remoteDeviceDiscoveryStarted(RegistryImpl.this, device);
                }
            });
        }
        return true;
    }

    @Override
    public void notifyDiscoveryFailure(final RemoteDevice device, final Exception ex) {
        for (final RegistryListener listener : this.getListeners()) {
            this.getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    listener.remoteDeviceDiscoveryFailed(RegistryImpl.this, device, ex);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDevice(LocalDevice localDevice) {
        LocalItems localItems = this.localItems;
        synchronized (localItems) {
            this.localItems.add(localDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDevice(LocalDevice localDevice, DiscoveryOptions options) {
        LocalItems localItems = this.localItems;
        synchronized (localItems) {
            this.localItems.add(localDevice, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDiscoveryOptions(UDN udn, DiscoveryOptions options) {
        LocalItems localItems = this.localItems;
        synchronized (localItems) {
            this.localItems.setDiscoveryOptions(udn, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiscoveryOptions getDiscoveryOptions(UDN udn) {
        LocalItems localItems = this.localItems;
        synchronized (localItems) {
            return this.localItems.getDiscoveryOptions(udn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDevice(RemoteDevice remoteDevice) {
        RemoteItems remoteItems = this.remoteItems;
        synchronized (remoteItems) {
            this.remoteItems.add(remoteDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(RemoteDeviceIdentity rdIdentity) {
        RemoteItems remoteItems = this.remoteItems;
        synchronized (remoteItems) {
            return this.remoteItems.update(rdIdentity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeDevice(LocalDevice localDevice) {
        LocalItems localItems = this.localItems;
        synchronized (localItems) {
            return this.localItems.remove(localDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeDevice(RemoteDevice remoteDevice) {
        RemoteItems remoteItems = this.remoteItems;
        synchronized (remoteItems) {
            return this.remoteItems.remove(remoteDevice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllLocalDevices() {
        LocalItems localItems = this.localItems;
        synchronized (localItems) {
            this.localItems.removeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllRemoteDevices() {
        RemoteItems remoteItems = this.remoteItems;
        synchronized (remoteItems) {
            this.remoteItems.removeAll();
        }
    }

    @Override
    public boolean removeDevice(UDN udn) {
        Device device = this.getDevice(udn, true);
        if (device != null && device instanceof LocalDevice) {
            return this.removeDevice((LocalDevice)device);
        }
        if (device != null && device instanceof RemoteDevice) {
            return this.removeDevice((RemoteDevice)device);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Device getDevice(UDN udn, boolean rootOnly) {
        Object device;
        RegistryItems registryItems = this.localItems;
        synchronized (registryItems) {
            device = this.localItems.get(udn, rootOnly);
            if (device != null) {
                return device;
            }
        }
        registryItems = this.remoteItems;
        synchronized (registryItems) {
            device = this.remoteItems.get(udn, rootOnly);
            if (device != null) {
                return device;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalDevice getLocalDevice(UDN udn, boolean rootOnly) {
        LocalItems localItems = this.localItems;
        synchronized (localItems) {
            return (LocalDevice)this.localItems.get(udn, rootOnly);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteDevice getRemoteDevice(UDN udn, boolean rootOnly) {
        RemoteItems remoteItems = this.remoteItems;
        synchronized (remoteItems) {
            return (RemoteDevice)this.remoteItems.get(udn, rootOnly);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<LocalDevice> getLocalDevices() {
        LocalItems localItems = this.localItems;
        synchronized (localItems) {
            return Collections.unmodifiableCollection(this.localItems.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<RemoteDevice> getRemoteDevices() {
        RemoteItems remoteItems = this.remoteItems;
        synchronized (remoteItems) {
            return Collections.unmodifiableCollection(this.remoteItems.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Device> getDevices() {
        HashSet<LocalDevice> all = new HashSet<LocalDevice>();
        RegistryItems registryItems = this.localItems;
        synchronized (registryItems) {
            all.addAll(this.localItems.get());
        }
        registryItems = this.remoteItems;
        synchronized (registryItems) {
            all.addAll(this.remoteItems.get());
        }
        return Collections.unmodifiableCollection(all);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Device> getDevices(DeviceType deviceType) {
        HashSet devices = new HashSet();
        RegistryItems registryItems = this.localItems;
        synchronized (registryItems) {
            devices.addAll(this.localItems.get(deviceType));
        }
        registryItems = this.remoteItems;
        synchronized (registryItems) {
            devices.addAll(this.remoteItems.get(deviceType));
        }
        return Collections.unmodifiableCollection(devices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Device> getDevices(ServiceType serviceType) {
        HashSet devices = new HashSet();
        RegistryItems registryItems = this.localItems;
        synchronized (registryItems) {
            devices.addAll(this.localItems.get(serviceType));
        }
        registryItems = this.remoteItems;
        synchronized (registryItems) {
            devices.addAll(this.remoteItems.get(serviceType));
        }
        return Collections.unmodifiableCollection(devices);
    }

    @Override
    public Service getService(ServiceReference serviceReference) {
        Device device = this.getDevice(serviceReference.getUdn(), false);
        if (device != null) {
            return device.findService(serviceReference.getServiceId());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getResource(URI pathQuery) throws IllegalArgumentException {
        if (pathQuery.isAbsolute()) {
            throw new IllegalArgumentException("Resource URI can not be absolute, only path and query:" + pathQuery);
        }
        Set<RegistryItem<URI, Resource>> set = this.resourceItems;
        synchronized (set) {
            for (RegistryItem<URI, Resource> resourceItem : this.resourceItems) {
                Resource resource = resourceItem.getItem();
                if (!resource.matches(pathQuery)) continue;
                return resource;
            }
        }
        set = this.resourceItems;
        synchronized (set) {
            if (pathQuery.getPath().endsWith("/")) {
                URI pathQueryWithoutSlash = URI.create(pathQuery.toString().substring(0, pathQuery.toString().length() - 1));
                for (RegistryItem<URI, Resource> resourceItem : this.resourceItems) {
                    Resource resource = resourceItem.getItem();
                    if (!resource.matches(pathQueryWithoutSlash)) continue;
                    return resource;
                }
            }
        }
        return null;
    }

    @Override
    public <T extends Resource> T getResource(Class<T> resourceType, URI pathQuery) throws IllegalArgumentException {
        Resource resource = this.getResource(pathQuery);
        if (resource != null && resourceType.isAssignableFrom(resource.getClass())) {
            return (T)resource;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Resource> getResources() {
        HashSet<Resource> s = new HashSet<Resource>();
        Set<RegistryItem<URI, Resource>> set = this.resourceItems;
        synchronized (set) {
            for (RegistryItem<URI, Resource> resourceItem : this.resourceItems) {
                s.add(resourceItem.getItem());
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Resource> Collection<T> getResources(Class<T> resourceType) {
        HashSet<Resource> s = new HashSet<Resource>();
        Set<RegistryItem<URI, Resource>> set = this.resourceItems;
        synchronized (set) {
            for (RegistryItem<URI, Resource> resourceItem : this.resourceItems) {
                if (!resourceType.isAssignableFrom(resourceItem.getItem().getClass())) continue;
                s.add(resourceItem.getItem());
            }
        }
        return s;
    }

    @Override
    public void addResource(Resource resource) {
        this.addResource(resource, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResource(Resource resource, int maxAgeSeconds) {
        RegistryItem<URI, Resource> resourceItem = new RegistryItem<URI, Resource>(resource.getPathQuery(), resource, maxAgeSeconds);
        Set<RegistryItem<URI, Resource>> set = this.resourceItems;
        synchronized (set) {
            this.resourceItems.remove(resourceItem);
            this.resourceItems.add(resourceItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeResource(Resource resource) {
        Set<RegistryItem<URI, Resource>> set = this.resourceItems;
        synchronized (set) {
            return this.resourceItems.remove(new RegistryItem(resource.getPathQuery()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLocalSubscription(LocalGENASubscription subscription) {
        LocalItems localItems = this.localItems;
        synchronized (localItems) {
            this.localItems.addSubscription(subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalGENASubscription getLocalSubscription(String subscriptionId) {
        LocalItems localItems = this.localItems;
        synchronized (localItems) {
            return (LocalGENASubscription)this.localItems.getSubscription(subscriptionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateLocalSubscription(LocalGENASubscription subscription) {
        LocalItems localItems = this.localItems;
        synchronized (localItems) {
            return this.localItems.updateSubscription(subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeLocalSubscription(LocalGENASubscription subscription) {
        LocalItems localItems = this.localItems;
        synchronized (localItems) {
            return this.localItems.removeSubscription(subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRemoteSubscription(RemoteGENASubscription subscription) {
        RemoteItems remoteItems = this.remoteItems;
        synchronized (remoteItems) {
            this.remoteItems.addSubscription(subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteGENASubscription getRemoteSubscription(String subscriptionId) {
        RemoteItems remoteItems = this.remoteItems;
        synchronized (remoteItems) {
            return (RemoteGENASubscription)this.remoteItems.getSubscription(subscriptionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRemoteSubscription(RemoteGENASubscription subscription) {
        RemoteItems remoteItems = this.remoteItems;
        synchronized (remoteItems) {
            this.remoteItems.updateSubscription(subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRemoteSubscription(RemoteGENASubscription subscription) {
        RemoteItems remoteItems = this.remoteItems;
        synchronized (remoteItems) {
            this.remoteItems.removeSubscription(subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void advertiseLocalDevices() {
        LocalItems localItems = this.localItems;
        synchronized (localItems) {
            this.localItems.advertiseLocalDevices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.log.trace("Shutting down registry...");
        Set<RegistryListener> set = this.lock;
        synchronized (set) {
            if (this.registryMaintainer != null) {
                this.registryMaintainer.stop();
            }
        }
        set = this.pendingExecutions;
        synchronized (set) {
            this.log.trace("Executing final pending operations on shutdown: {}", (Object)this.pendingExecutions.size());
            this.runPendingExecutions(false);
        }
        set = this.registryListeners;
        synchronized (set) {
            for (RegistryListener listener : this.registryListeners) {
                listener.beforeShutdown(this);
            }
        }
        set = this.resourceItems;
        synchronized (set) {
            RegistryItem[] resources;
            RegistryItem[] registryItemArray = resources = this.resourceItems.toArray(new RegistryItem[this.resourceItems.size()]);
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                RegistryItem resourceItem = registryItemArray[n2];
                ((Resource)resourceItem.getItem()).shutdown();
                ++n2;
            }
        }
        set = this.remoteItems;
        synchronized (set) {
            this.remoteItems.shutdown();
        }
        set = this.localItems;
        synchronized (set) {
            this.localItems.shutdown();
        }
        set = this.registryListeners;
        synchronized (set) {
            for (RegistryListener listener : this.registryListeners) {
                listener.afterShutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.lock;
        synchronized (object) {
            if (this.registryMaintainer != null) {
                this.log.trace("Pausing registry maintenance");
                this.runPendingExecutions(true);
                this.registryMaintainer.stop();
                this.registryMaintainer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            if (this.registryMaintainer == null) {
                this.log.trace("Resuming registry maintenance");
                RemoteItems remoteItems = this.remoteItems;
                synchronized (remoteItems) {
                    this.remoteItems.resume();
                }
                this.registryMaintainer = this.createRegistryMaintainer();
                if (this.registryMaintainer != null) {
                    this.getConfiguration().getRegistryMaintainerExecutor().execute(this.registryMaintainer);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPaused() {
        Object object = this.lock;
        synchronized (object) {
            return this.registryMaintainer == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void maintain() {
        this.log.trace("Maintaining registry...");
        Object object = this.resourceItems;
        synchronized (object) {
            Iterator<RegistryItem<URI, Resource>> it = this.resourceItems.iterator();
            while (it.hasNext()) {
                RegistryItem<URI, Resource> item = it.next();
                if (!item.getExpirationDetails().hasExpired()) continue;
                this.log.trace("Removing expired resource: " + item);
                it.remove();
            }
            List<Runnable> list = this.pendingExecutions;
            synchronized (list) {
                for (RegistryItem<URI, Resource> resourceItem : this.resourceItems) {
                    resourceItem.getItem().maintain(this.pendingExecutions, resourceItem.getExpirationDetails());
                }
            }
        }
        object = this.remoteItems;
        synchronized (object) {
            this.remoteItems.maintain();
        }
        object = this.localItems;
        synchronized (object) {
            this.localItems.maintain();
        }
        this.runPendingExecutions(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeAsyncProtocol(Runnable runnable) {
        List<Runnable> list = this.pendingExecutions;
        synchronized (list) {
            this.pendingExecutions.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runPendingExecutions(boolean async) {
        List<Runnable> list = this.pendingExecutions;
        synchronized (list) {
            this.log.trace("Executing pending operations: {}", (Object)this.pendingExecutions.size());
            for (Runnable pendingExecution : this.pendingExecutions) {
                if (async) {
                    this.getConfiguration().getAsyncProtocolExecutor().execute(pendingExecution);
                    continue;
                }
                pendingExecution.run();
            }
            if (this.pendingExecutions.size() > 0) {
                this.pendingExecutions.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printDebugLog() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("====================================    REMOTE   ================================================");
            Object object = this.remoteItems;
            synchronized (object) {
                for (RemoteDevice remoteDevice : this.remoteItems.get()) {
                    this.log.trace(remoteDevice.toString());
                }
            }
            this.log.trace("====================================    LOCAL    ================================================");
            object = this.localItems;
            synchronized (object) {
                for (LocalDevice localDevice : this.localItems.get()) {
                    this.log.trace(localDevice.toString());
                }
            }
            this.log.trace("====================================  RESOURCES  ================================================");
            object = this.resourceItems;
            synchronized (object) {
                for (RegistryItem registryItem : this.resourceItems) {
                    this.log.trace(registryItem.toString());
                }
            }
            this.log.trace("=================================================================================================");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerPendingRemoteSubscription(RemoteGENASubscription subscription) {
        Set<RemoteGENASubscription> set = this.pendingSubscriptionsLock;
        synchronized (set) {
            this.pendingSubscriptionsLock.add(subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterPendingRemoteSubscription(RemoteGENASubscription subscription) {
        Set<RemoteGENASubscription> set = this.pendingSubscriptionsLock;
        synchronized (set) {
            if (this.pendingSubscriptionsLock.remove(subscription)) {
                this.pendingSubscriptionsLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteGENASubscription getWaitRemoteSubscription(String subscriptionId) {
        Set<RemoteGENASubscription> set = this.pendingSubscriptionsLock;
        synchronized (set) {
            do {
                RemoteGENASubscription subscription;
                if ((subscription = this.getRemoteSubscription(subscriptionId)) != null) {
                    return subscription;
                }
                if (this.pendingSubscriptionsLock.isEmpty()) continue;
                try {
                    this.log.trace("Subscription not found, waiting for pending subscription procedure to terminate.");
                    this.pendingSubscriptionsLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            } while (!this.pendingSubscriptionsLock.isEmpty());
        }
        return null;
    }
}

