/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.net.www.protocol.http.Handler;
import sun.net.www.protocol.http.HttpURLConnection;

public class FixedSunURLStreamHandler
implements URLStreamHandlerFactory {
    private final Logger log = LoggerFactory.getLogger((String)FixedSunURLStreamHandler.class.getName());

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        this.log.trace("Creating new URLStreamHandler for protocol: {}", (Object)protocol);
        if ("http".equals(protocol)) {
            return new Handler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    return this.openConnection(u, null);
                }

                @Override
                protected URLConnection openConnection(URL u, Proxy p) throws IOException {
                    return new UpnpURLConnection(u, this);
                }
            };
        }
        return null;
    }

    static class UpnpURLConnection
    extends HttpURLConnection {
        private static final String[] methods = new String[]{"GET", "POST", "HEAD", "OPTIONS", "PUT", "DELETE", "SUBSCRIBE", "UNSUBSCRIBE", "NOTIFY"};

        protected UpnpURLConnection(URL u, Handler handler) throws IOException {
            super(u, handler);
        }

        public UpnpURLConnection(URL u, String host, int port) throws IOException {
            super(u, host, port);
        }

        @Override
        public synchronized OutputStream getOutputStream() throws IOException {
            String savedMethod = this.method;
            this.method = this.method.equals("PUT") || this.method.equals("POST") || this.method.equals("NOTIFY") ? "PUT" : "GET";
            OutputStream os = super.getOutputStream();
            this.method = savedMethod;
            return os;
        }

        @Override
        public void setRequestMethod(String method) throws ProtocolException {
            if (this.connected) {
                throw new ProtocolException("Cannot reset method once connected");
            }
            String[] stringArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                String m = stringArray[n2];
                if (m.equals(method)) {
                    this.method = method;
                    return;
                }
                ++n2;
            }
            throw new ProtocolException("Invalid UPnP HTTP method: " + method);
        }
    }
}

