/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.model.XMLUtil;
import org.jupnp.model.message.UpnpMessage;
import org.jupnp.model.message.gena.IncomingEventRequestMessage;
import org.jupnp.model.message.gena.OutgoingEventRequestMessage;
import org.jupnp.model.meta.StateVariable;
import org.jupnp.model.state.StateVariableValue;
import org.jupnp.transport.impl.PooledXmlProcessor;
import org.jupnp.transport.spi.GENAEventProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class GENAEventProcessorImpl
extends PooledXmlProcessor
implements GENAEventProcessor,
ErrorHandler {
    private Logger log = LoggerFactory.getLogger(GENAEventProcessor.class);

    protected DocumentBuilderFactory createDocumentBuilderFactory() throws FactoryConfigurationError {
        return DocumentBuilderFactory.newInstance();
    }

    @Override
    public void writeBody(OutgoingEventRequestMessage requestMessage) throws UnsupportedDataException {
        this.log.trace("Writing body of: " + requestMessage);
        try {
            Document d = this.newDocument();
            Element propertysetElement = this.writePropertysetElement(d);
            this.writeProperties(d, propertysetElement, requestMessage);
            requestMessage.setBody(UpnpMessage.BodyType.STRING, this.toString(d));
            if (this.log.isTraceEnabled()) {
                this.log.trace("===================================== GENA BODY BEGIN ============================================");
                this.log.trace(requestMessage.getBody().toString());
                this.log.trace("====================================== GENA BODY END =============================================");
            }
        }
        catch (Exception ex) {
            throw new UnsupportedDataException("Can't transform message payload: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void readBody(IncomingEventRequestMessage requestMessage) throws UnsupportedDataException {
        this.log.trace("Reading body of: " + requestMessage);
        if (this.log.isTraceEnabled()) {
            this.log.trace("===================================== GENA BODY BEGIN ============================================");
            this.log.trace(requestMessage.getBody() != null ? requestMessage.getBody().toString() : "null");
            this.log.trace("-===================================== GENA BODY END ============================================");
        }
        String body = this.getMessageBody(requestMessage);
        try {
            Document d = this.readDocument(new InputSource(new StringReader(body)), this);
            Element propertysetElement = this.readPropertysetElement(d);
            this.readProperties(propertysetElement, requestMessage);
        }
        catch (Exception ex) {
            throw new UnsupportedDataException("Can't transform message payload: " + ex.getMessage(), ex, body);
        }
    }

    protected Element writePropertysetElement(Document d) {
        Element propertysetElement = d.createElementNS("urn:schemas-upnp-org:event-1-0", "e:propertyset");
        d.appendChild(propertysetElement);
        return propertysetElement;
    }

    protected Element readPropertysetElement(Document d) {
        Element propertysetElement = d.getDocumentElement();
        if (propertysetElement == null || !this.getUnprefixedNodeName(propertysetElement).equals("propertyset")) {
            throw new RuntimeException("Root element was not 'propertyset'");
        }
        return propertysetElement;
    }

    protected void writeProperties(Document d, Element propertysetElement, OutgoingEventRequestMessage message) {
        for (StateVariableValue stateVariableValue : message.getStateVariableValues()) {
            Element propertyElement = d.createElementNS("urn:schemas-upnp-org:event-1-0", "e:property");
            propertysetElement.appendChild(propertyElement);
            XMLUtil.appendNewElement(d, propertyElement, stateVariableValue.getStateVariable().getName(), stateVariableValue.toString());
        }
    }

    protected void readProperties(Element propertysetElement, IncomingEventRequestMessage message) {
        NodeList propertysetElementChildren = propertysetElement.getChildNodes();
        StateVariable<S>[] stateVariables = message.getService().getStateVariables();
        int i = 0;
        while (i < propertysetElementChildren.getLength()) {
            Node propertysetChild = propertysetElementChildren.item(i);
            if (propertysetChild.getNodeType() == 1 && this.getUnprefixedNodeName(propertysetChild).equals("property")) {
                NodeList propertyChildren = propertysetChild.getChildNodes();
                int j = 0;
                while (j < propertyChildren.getLength()) {
                    Node propertyChild = propertyChildren.item(j);
                    if (propertyChild.getNodeType() == 1) {
                        String stateVariableName = this.getUnprefixedNodeName(propertyChild);
                        StateVariable<S>[] stateVariableArray = stateVariables;
                        int n = stateVariables.length;
                        int n2 = 0;
                        while (n2 < n) {
                            StateVariable stateVariable = stateVariableArray[n2];
                            if (stateVariable.getName().equals(stateVariableName)) {
                                this.log.trace("Reading state variable value: " + stateVariableName);
                                String value = XMLUtil.getTextContent(propertyChild);
                                message.getStateVariableValues().add(new StateVariableValue(stateVariable, (Object)value));
                                break;
                            }
                            ++n2;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected String getMessageBody(UpnpMessage message) throws UnsupportedDataException {
        if (!message.isBodyNonEmptyString()) {
            throw new UnsupportedDataException("Can't transform null or non-string/zero-length body of: " + message);
        }
        return message.getBodyString().trim();
    }

    protected String toString(Document d) throws Exception {
        String output = XMLUtil.documentToString(d);
        while (output.endsWith("\n") || output.endsWith("\r")) {
            output = output.substring(0, output.length() - 1);
        }
        return output;
    }

    protected String getUnprefixedNodeName(Node node) {
        return node.getPrefix() != null ? node.getNodeName().substring(node.getPrefix().length() + 1) : node.getNodeName();
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.log.warn(e.toString());
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }
}

