/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jupnp.transport.spi.InitializationException;
import org.jupnp.transport.spi.NetworkAddressFactory;
import org.jupnp.transport.spi.NoNetworkException;
import org.jupnp.util.Iterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkAddressFactoryImpl
implements NetworkAddressFactory {
    public static final int DEFAULT_TCP_HTTP_LISTEN_PORT = 0;
    public static final int DEFAULT_MULTICAST_RESPONSE_LISTEN_PORT = 0;
    private Logger log = LoggerFactory.getLogger(NetworkAddressFactoryImpl.class);
    protected final Set<String> useInterfaces = new HashSet<String>();
    protected final Set<String> useAddresses = new HashSet<String>();
    protected final List<NetworkInterface> networkInterfaces = new ArrayList<NetworkInterface>();
    protected final List<InetAddress> bindAddresses = new ArrayList<InetAddress>();
    protected int streamListenPort;
    protected int multicastResponsePort;

    public NetworkAddressFactoryImpl() throws InitializationException {
        this(0, 0);
    }

    public NetworkAddressFactoryImpl(int streamListenPort, int multicastResponsePort) throws InitializationException {
        String useAddressesString;
        System.setProperty("java.net.preferIPv4Stack", "true");
        String useInterfacesString = System.getProperty("org.jupnp.network.useInterfaces");
        if (useInterfacesString != null) {
            String[] userInterfacesStrings = useInterfacesString.split(",");
            this.useInterfaces.addAll(Arrays.asList(userInterfacesStrings));
        }
        if ((useAddressesString = System.getProperty("org.jupnp.network.useAddresses")) != null) {
            String[] useAddressesStrings = useAddressesString.split(",");
            this.useAddresses.addAll(Arrays.asList(useAddressesStrings));
        }
        this.discoverNetworkInterfaces();
        this.discoverBindAddresses();
        if (this.networkInterfaces.size() == 0 || this.bindAddresses.size() == 0) {
            this.log.warn("No usable network interface or addresses found");
            if (this.requiresNetworkInterface()) {
                throw new NoNetworkException("Could not discover any usable network interfaces and/or addresses");
            }
        }
        this.streamListenPort = streamListenPort;
        this.multicastResponsePort = multicastResponsePort;
    }

    protected boolean requiresNetworkInterface() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logInterfaceInformation() {
        List<NetworkInterface> list = this.networkInterfaces;
        synchronized (list) {
            if (this.networkInterfaces.isEmpty()) {
                this.log.info("No network interface to display!");
                return;
            }
            for (NetworkInterface networkInterface : this.networkInterfaces) {
                try {
                    this.logInterfaceInformation(networkInterface);
                }
                catch (SocketException ex) {
                    this.log.warn("Exception while logging network interface information", (Throwable)ex);
                }
            }
        }
    }

    @Override
    public InetAddress getMulticastGroup() {
        try {
            return InetAddress.getByName("239.255.255.250");
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public int getMulticastPort() {
        return 1900;
    }

    @Override
    public int getMulticastResponsePort() {
        return this.multicastResponsePort > 0 ? this.multicastResponsePort : 0;
    }

    @Override
    public int getStreamListenPort() {
        return this.streamListenPort;
    }

    @Override
    public Iterator<NetworkInterface> getNetworkInterfaces() {
        return new Iterators.Synchronized<NetworkInterface>(this.networkInterfaces){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void synchronizedRemove(int index) {
                List<NetworkInterface> list = NetworkAddressFactoryImpl.this.networkInterfaces;
                synchronized (list) {
                    NetworkAddressFactoryImpl.this.networkInterfaces.remove(index);
                }
            }
        };
    }

    @Override
    public Iterator<InetAddress> getBindAddresses() {
        return new Iterators.Synchronized<InetAddress>(this.bindAddresses){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void synchronizedRemove(int index) {
                List<InetAddress> list = NetworkAddressFactoryImpl.this.bindAddresses;
                synchronized (list) {
                    NetworkAddressFactoryImpl.this.bindAddresses.remove(index);
                }
            }
        };
    }

    @Override
    public boolean hasUsableNetwork() {
        return this.networkInterfaces.size() > 0 && this.bindAddresses.size() > 0;
    }

    @Override
    public byte[] getHardwareAddress(InetAddress inetAddress) {
        try {
            NetworkInterface iface = NetworkInterface.getByInetAddress(inetAddress);
            return iface != null ? iface.getHardwareAddress() : null;
        }
        catch (Throwable ex) {
            this.log.warn("Cannot get hardware address for: " + inetAddress, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetAddress getBroadcastAddress(InetAddress inetAddress) {
        List<NetworkInterface> list = this.networkInterfaces;
        synchronized (list) {
            for (NetworkInterface iface : this.networkInterfaces) {
                for (InterfaceAddress interfaceAddress : this.getInterfaceAddresses(iface)) {
                    if (interfaceAddress == null || !interfaceAddress.getAddress().equals(inetAddress)) continue;
                    return interfaceAddress.getBroadcast();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Short getAddressNetworkPrefixLength(InetAddress inetAddress) {
        List<NetworkInterface> list = this.networkInterfaces;
        synchronized (list) {
            InterfaceAddress interfaceAddress;
            Iterator<NetworkInterface> iterator = this.networkInterfaces.iterator();
            block3: while (true) {
                if (!iterator.hasNext()) {
                    return null;
                }
                NetworkInterface iface = iterator.next();
                Iterator<InterfaceAddress> iterator2 = this.getInterfaceAddresses(iface).iterator();
                do {
                    if (!iterator2.hasNext()) continue block3;
                } while ((interfaceAddress = iterator2.next()) == null || !interfaceAddress.getAddress().equals(inetAddress));
                break;
            }
            short prefix = interfaceAddress.getNetworkPrefixLength();
            if (prefix <= 0) return null;
            if (prefix >= 32) return null;
            return prefix;
        }
    }

    @Override
    public InetAddress getLocalAddress(NetworkInterface networkInterface, boolean isIPv6, InetAddress remoteAddress) {
        InetAddress localIPInSubnet = this.getBindAddressInSubnetOf(remoteAddress);
        if (localIPInSubnet != null) {
            return localIPInSubnet;
        }
        this.log.trace("Could not find local bind address in same subnet as: " + remoteAddress.getHostAddress());
        for (InetAddress interfaceAddress : this.getInetAddresses(networkInterface)) {
            if (isIPv6 && interfaceAddress instanceof Inet6Address) {
                return interfaceAddress;
            }
            if (isIPv6 || !(interfaceAddress instanceof Inet4Address)) continue;
            return interfaceAddress;
        }
        throw new IllegalStateException("Can't find any IPv4 or IPv6 address on interface: " + networkInterface.getDisplayName());
    }

    protected List<InterfaceAddress> getInterfaceAddresses(NetworkInterface networkInterface) {
        return networkInterface.getInterfaceAddresses();
    }

    protected List<InetAddress> getInetAddresses(NetworkInterface networkInterface) {
        return Collections.list(networkInterface.getInetAddresses());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InetAddress getBindAddressInSubnetOf(InetAddress inetAddress) {
        List<NetworkInterface> list = this.networkInterfaces;
        synchronized (list) {
            for (NetworkInterface iface : this.networkInterfaces) {
                for (InterfaceAddress ifaceAddress : this.getInterfaceAddresses(iface)) {
                    List<InetAddress> list2 = this.bindAddresses;
                    synchronized (list2) {
                        if (ifaceAddress == null || !this.bindAddresses.contains(ifaceAddress.getAddress())) {
                            continue;
                        }
                    }
                    if (!this.isInSubnet(inetAddress.getAddress(), ifaceAddress.getAddress().getAddress(), ifaceAddress.getNetworkPrefixLength())) continue;
                    return ifaceAddress.getAddress();
                }
            }
        }
        return null;
    }

    protected boolean isInSubnet(byte[] ip, byte[] network, short prefix) {
        if (ip.length != network.length) {
            return false;
        }
        if (prefix / 8 > ip.length) {
            return false;
        }
        int i = 0;
        while (prefix >= 8 && i < ip.length) {
            if (ip[i] != network[i]) {
                return false;
            }
            ++i;
            prefix = (short)(prefix - 8);
        }
        if (i == ip.length) {
            return true;
        }
        byte mask = (byte)(~((1 << 8 - prefix) - 1));
        return (ip[i] & mask) == (network[i] & mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discoverNetworkInterfaces() throws InitializationException {
        try {
            Enumeration<NetworkInterface> interfaceEnumeration = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface iface : Collections.list(interfaceEnumeration)) {
                this.log.trace("Analyzing network interface: " + iface.getDisplayName());
                if (this.isUsableNetworkInterface(iface)) {
                    this.log.trace("Discovered usable network interface: " + iface.getDisplayName());
                    List<NetworkInterface> list = this.networkInterfaces;
                    synchronized (list) {
                        this.networkInterfaces.add(iface);
                        continue;
                    }
                }
                this.log.trace("Ignoring non-usable network interface: " + iface.getDisplayName());
            }
        }
        catch (Exception ex) {
            throw new InitializationException("Could not not analyze local network interfaces: " + ex, ex);
        }
    }

    protected boolean isUsableNetworkInterface(NetworkInterface iface) throws Exception {
        if (!iface.isUp()) {
            this.log.trace("Skipping network interface (down): " + iface.getDisplayName());
            return false;
        }
        if (this.getInetAddresses(iface).size() == 0) {
            this.log.trace("Skipping network interface without bound IP addresses: " + iface.getDisplayName());
            return false;
        }
        if (iface.getName().toLowerCase(Locale.ENGLISH).startsWith("vmnet") || iface.getDisplayName() != null && iface.getDisplayName().toLowerCase(Locale.ENGLISH).contains("vmnet")) {
            this.log.trace("Skipping network interface (VMWare): " + iface.getDisplayName());
            return false;
        }
        if (iface.getName().toLowerCase(Locale.ENGLISH).startsWith("vnic")) {
            this.log.trace("Skipping network interface (Parallels): " + iface.getDisplayName());
            return false;
        }
        if (iface.getName().toLowerCase(Locale.ENGLISH).startsWith("vboxnet")) {
            this.log.trace("Skipping network interface (Virtual Box): " + iface.getDisplayName());
            return false;
        }
        if (iface.getName().toLowerCase(Locale.ENGLISH).contains("virtual")) {
            this.log.trace("Skipping network interface (named '*virtual*'): " + iface.getDisplayName());
            return false;
        }
        if (iface.getName().toLowerCase(Locale.ENGLISH).startsWith("ppp")) {
            this.log.trace("Skipping network interface (PPP): " + iface.getDisplayName());
            return false;
        }
        if (iface.isLoopback()) {
            this.log.trace("Skipping network interface (ignoring loopback): " + iface.getDisplayName());
            return false;
        }
        if (this.useInterfaces.size() > 0 && !this.useInterfaces.contains(iface.getName())) {
            this.log.trace("Skipping unwanted network interface (-Dorg.jupnp.network.useInterfaces): " + iface.getName());
            return false;
        }
        if (!iface.supportsMulticast()) {
            this.log.warn("Network interface may not be multicast capable: " + iface.getDisplayName());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discoverBindAddresses() throws InitializationException {
        try {
            List<NetworkInterface> list = this.networkInterfaces;
            synchronized (list) {
                Iterator<NetworkInterface> it = this.networkInterfaces.iterator();
                while (it.hasNext()) {
                    NetworkInterface networkInterface = it.next();
                    this.log.trace("Discovering addresses of interface: " + networkInterface.getDisplayName());
                    int usableAddresses = 0;
                    for (InetAddress inetAddress : this.getInetAddresses(networkInterface)) {
                        if (inetAddress == null) {
                            this.log.warn("Network has a null address: " + networkInterface.getDisplayName());
                            continue;
                        }
                        if (this.isUsableAddress(networkInterface, inetAddress)) {
                            this.log.trace("Discovered usable network interface address: " + inetAddress.getHostAddress());
                            ++usableAddresses;
                            List<InetAddress> list2 = this.bindAddresses;
                            synchronized (list2) {
                                this.bindAddresses.add(inetAddress);
                                continue;
                            }
                        }
                        this.log.trace("Ignoring non-usable network interface address: " + inetAddress.getHostAddress());
                    }
                    if (usableAddresses != 0) continue;
                    this.log.trace("Network interface has no usable addresses, removing: " + networkInterface.getDisplayName());
                    it.remove();
                }
            }
        }
        catch (Exception ex) {
            throw new InitializationException("Could not not analyze local network interfaces: " + ex, ex);
        }
    }

    protected boolean isUsableAddress(NetworkInterface networkInterface, InetAddress address) {
        if (!(address instanceof Inet4Address)) {
            this.log.trace("Skipping unsupported non-IPv4 address: " + address);
            return false;
        }
        if (address.isLoopbackAddress()) {
            this.log.trace("Skipping loopback address: " + address);
            return false;
        }
        if (this.useAddresses.size() > 0 && !this.useAddresses.contains(address.getHostAddress())) {
            this.log.trace("Skipping unwanted address: " + address);
            return false;
        }
        return true;
    }

    protected void logInterfaceInformation(NetworkInterface networkInterface) throws SocketException {
        this.log.info("---------------------------------------------------------------------------------");
        this.log.info("Interface display name: {}", (Object)networkInterface.getDisplayName());
        if (networkInterface.getParent() != null) {
            this.log.info("Parent Info: {}", (Object)networkInterface.getParent());
        }
        this.log.info("Name: {}", (Object)networkInterface.getName());
        Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
        for (InetAddress inetAddress : Collections.list(inetAddresses)) {
            this.log.info("InetAddress: {}", (Object)inetAddress);
        }
        List<InterfaceAddress> interfaceAddresses = networkInterface.getInterfaceAddresses();
        for (InterfaceAddress interfaceAddress : interfaceAddresses) {
            if (interfaceAddress == null) {
                this.log.warn("Skipping null InterfaceAddress!");
                continue;
            }
            this.log.info(" Interface Address");
            this.log.info("  Address: " + interfaceAddress.getAddress());
            this.log.info("  Broadcast: " + interfaceAddress.getBroadcast());
            this.log.info("  Prefix length: " + interfaceAddress.getNetworkPrefixLength());
        }
        Enumeration<NetworkInterface> subIfs = networkInterface.getSubInterfaces();
        for (NetworkInterface subIf : Collections.list(subIfs)) {
            if (subIf == null) {
                this.log.warn("Skipping null NetworkInterface sub-interface");
                continue;
            }
            this.log.info("\tSub Interface Display name: {}", (Object)subIf.getDisplayName());
            this.log.info("\tSub Interface Name: {}", (Object)subIf.getName());
        }
        this.log.info("Up? {}", (Object)networkInterface.isUp());
        this.log.info("Loopback? {}", (Object)networkInterface.isLoopback());
        this.log.info("PointToPoint? {}", (Object)networkInterface.isPointToPoint());
        this.log.info("Supports multicast? {}", (Object)networkInterface.supportsMulticast());
        this.log.info("Virtual? {}", (Object)networkInterface.isVirtual());
        this.log.info("Hardware address: {}", (Object)Arrays.toString(networkInterface.getHardwareAddress()));
        this.log.info("MTU: {}", (Object)networkInterface.getMTU());
    }
}

