/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.List;
import java.util.Map;
import org.jupnp.http.Headers;
import org.jupnp.model.ModelUtil;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.UpnpMessage;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.transport.impl.StreamClientConfigurationImpl;
import org.jupnp.transport.spi.InitializationException;
import org.jupnp.transport.spi.StreamClient;
import org.jupnp.util.Exceptions;
import org.jupnp.util.URIUtil;
import org.jupnp.util.io.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamClientImpl
implements StreamClient {
    static final String HACK_STREAM_HANDLER_SYSTEM_PROPERTY = "hackStreamHandlerProperty";
    private final Logger log = LoggerFactory.getLogger((String)StreamClient.class.getName());
    protected final StreamClientConfigurationImpl configuration;

    public StreamClientImpl(StreamClientConfigurationImpl configuration) throws InitializationException {
        this.configuration = configuration;
        if (ModelUtil.ANDROID_EMULATOR || ModelUtil.ANDROID_RUNTIME) {
            throw new InitializationException("This client does not work on Android. The design of HttpURLConnection is broken, we can not add additional 'permitted' HTTP methods. Read the jUPnP manual.");
        }
        this.log.trace("Using persistent HTTP stream client connections: " + configuration.isUsePersistentConnections());
        System.setProperty("http.keepAlive", Boolean.toString(configuration.isUsePersistentConnections()));
        if (System.getProperty(HACK_STREAM_HANDLER_SYSTEM_PROPERTY) == null) {
            this.log.trace("Setting custom static URLStreamHandlerFactory to work around bad JDK defaults");
            try {
                URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)Class.forName("org.jupnp.transport.impl.FixedSunURLStreamHandler").newInstance());
            }
            catch (Throwable throwable) {
                throw new InitializationException("Failed to set modified URLStreamHandlerFactory in this environment. Can't use bundled default client based on HTTPURLConnection, see manual.");
            }
            System.setProperty(HACK_STREAM_HANDLER_SYSTEM_PROPERTY, "alreadyWorkedAroundTheEvilJDK");
        }
    }

    public StreamClientConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    @Override
    public StreamResponseMessage sendRequest(StreamRequestMessage requestMessage) {
        UpnpRequest requestOperation = (UpnpRequest)requestMessage.getOperation();
        this.log.trace("Preparing HTTP request message with method '{}': ", (Object)requestOperation.getHttpMethodName());
        URL url = URIUtil.toURL(requestOperation.getURI());
        HttpURLConnection urlConnection = null;
        try {
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod(requestOperation.getHttpMethodName());
            urlConnection.setReadTimeout(this.configuration.getTimeoutSeconds() * 1000);
            urlConnection.setConnectTimeout(this.configuration.getTimeoutSeconds() * 1000);
            this.applyRequestProperties(urlConnection, requestMessage);
            this.applyRequestBody(urlConnection, requestMessage);
            this.log.trace("Sending HTTP request: {}", (Object)requestMessage);
            InputStream inputStream = urlConnection.getInputStream();
            StreamResponseMessage streamResponseMessage = this.createResponse(urlConnection, inputStream);
            return streamResponseMessage;
        }
        catch (ProtocolException ex) {
            this.log.warn("HTTP request failed: {}", (Object)requestMessage, (Object)Exceptions.unwrap(ex));
            return null;
        }
        catch (IOException ex) {
            if (urlConnection == null) {
                this.log.warn("HTTP request failed: {}", (Object)requestMessage, (Object)Exceptions.unwrap(ex));
                return null;
            }
            if (ex instanceof SocketTimeoutException) {
                this.log.info("Timeout of {} seconds while waiting for HTTP request to complete, aborting: {}", (Object)this.getConfiguration().getTimeoutSeconds(), (Object)requestMessage);
                return null;
            }
            this.log.trace("Exception occurred, trying to read the error stream: {}", Exceptions.unwrap(ex));
            try {
                InputStream inputStream = urlConnection.getErrorStream();
                StreamResponseMessage streamResponseMessage = this.createResponse(urlConnection, inputStream);
                return streamResponseMessage;
            }
            catch (Exception errorEx) {
                this.log.trace("Could not read error stream: {}", (Throwable)errorEx);
                return null;
            }
        }
        catch (Exception ex) {
            this.log.warn("HTTP request failed: {}", (Object)requestMessage, (Object)Exceptions.unwrap(ex));
            return null;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    @Override
    public void stop() {
    }

    protected void applyRequestProperties(HttpURLConnection urlConnection, StreamRequestMessage requestMessage) {
        urlConnection.setInstanceFollowRedirects(false);
        if (!requestMessage.getHeaders().containsKey(UpnpHeader.Type.USER_AGENT)) {
            urlConnection.setRequestProperty(UpnpHeader.Type.USER_AGENT.getHttpName(), this.getConfiguration().getUserAgentValue(requestMessage.getUdaMajorVersion(), requestMessage.getUdaMinorVersion()));
        }
        this.applyHeaders(urlConnection, requestMessage.getHeaders());
    }

    protected void applyHeaders(HttpURLConnection urlConnection, Headers headers) {
        this.log.trace("Writing headers on HttpURLConnection: {}", (Object)headers.size());
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            for (String v : entry.getValue()) {
                String headerName = entry.getKey();
                this.log.trace("Setting header '{}': {}", (Object)headerName, (Object)v);
                urlConnection.setRequestProperty(headerName, v);
            }
        }
    }

    protected void applyRequestBody(HttpURLConnection urlConnection, StreamRequestMessage requestMessage) throws IOException {
        if (!requestMessage.hasBody()) {
            urlConnection.setDoOutput(false);
            return;
        }
        urlConnection.setDoOutput(true);
        if (requestMessage.getBodyType().equals((Object)UpnpMessage.BodyType.STRING)) {
            IO.writeUTF8(urlConnection.getOutputStream(), requestMessage.getBodyString());
        } else if (requestMessage.getBodyType().equals((Object)UpnpMessage.BodyType.BYTES)) {
            IO.writeBytes(urlConnection.getOutputStream(), requestMessage.getBodyBytes());
        }
        urlConnection.getOutputStream().flush();
    }

    protected StreamResponseMessage createResponse(HttpURLConnection urlConnection, InputStream inputStream) throws Exception {
        if (urlConnection.getResponseCode() == -1) {
            this.log.warn("Received an invalid HTTP response: {}", (Object)urlConnection.getURL());
            this.log.warn("Is your jUPnP-based server sending connection heartbeats with RemoteClientInfo#isRequestCancelled? This client can't handle heartbeats, read the manual.");
            return null;
        }
        UpnpResponse responseOperation = new UpnpResponse(urlConnection.getResponseCode(), urlConnection.getResponseMessage());
        this.log.trace("Received response: {}", (Object)responseOperation);
        StreamResponseMessage responseMessage = new StreamResponseMessage(responseOperation);
        responseMessage.setHeaders(new UpnpHeaders(urlConnection.getHeaderFields()));
        byte[] bodyBytes = null;
        try (InputStream is = null;){
            is = inputStream;
            if (inputStream != null) {
                bodyBytes = IO.readBytes(is);
            }
        }
        if (bodyBytes != null && bodyBytes.length > 0 && responseMessage.isContentTypeMissingOrText()) {
            this.log.trace("Response contains textual entity body, converting then setting string on message");
            responseMessage.setBodyCharacters(bodyBytes);
        } else if (bodyBytes != null && bodyBytes.length > 0) {
            this.log.trace("Response contains binary entity body, setting bytes on message");
            responseMessage.setBody(UpnpMessage.BodyType.BYTES, bodyBytes);
        } else {
            this.log.trace("Response did not contain entity body");
        }
        this.log.trace("Response message complete: {}", (Object)responseMessage);
        return responseMessage;
    }
}

