/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.jupnp.model.message.Connection;
import org.jupnp.transport.Router;
import org.jupnp.transport.impl.HttpExchangeUpnpStream;
import org.jupnp.transport.impl.StreamServerConfigurationImpl;
import org.jupnp.transport.spi.InitializationException;
import org.jupnp.transport.spi.StreamServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamServerImpl
implements StreamServer<StreamServerConfigurationImpl> {
    private Logger log = LoggerFactory.getLogger((String)StreamServer.class.getName());
    protected final StreamServerConfigurationImpl configuration;
    protected HttpServer server;

    public StreamServerImpl(StreamServerConfigurationImpl configuration) {
        this.configuration = configuration;
    }

    @Override
    public synchronized void init(InetAddress bindAddress, Router router) throws InitializationException {
        try {
            InetSocketAddress socketAddress = new InetSocketAddress(bindAddress, this.configuration.getListenPort());
            this.server = HttpServer.create(socketAddress, this.configuration.getTcpConnectionBacklog());
            this.server.createContext("/", new RequestHttpHandler(router));
            this.log.info("Created server (for receiving TCP streams) on: {}", (Object)this.server.getAddress());
        }
        catch (Exception ex) {
            throw new InitializationException("Could not initialize " + this.getClass().getSimpleName() + ": " + ex.toString(), ex);
        }
    }

    @Override
    public synchronized int getPort() {
        return this.server.getAddress().getPort();
    }

    @Override
    public StreamServerConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    @Override
    public synchronized void run() {
        this.log.trace("Starting StreamServer...");
        this.server.start();
    }

    @Override
    public synchronized void stop() {
        this.log.trace("Stopping StreamServer...");
        if (this.server != null) {
            this.server.stop(1);
        }
    }

    protected boolean isConnectionOpen(HttpExchange exchange) {
        this.log.warn("Can't check client connection, socket access impossible on JDK webserver!");
        return true;
    }

    protected class HttpServerConnection
    implements Connection {
        protected HttpExchange exchange;

        public HttpServerConnection(HttpExchange exchange) {
            this.exchange = exchange;
        }

        @Override
        public boolean isOpen() {
            return StreamServerImpl.this.isConnectionOpen(this.exchange);
        }

        @Override
        public InetAddress getRemoteAddress() {
            return this.exchange.getRemoteAddress() != null ? this.exchange.getRemoteAddress().getAddress() : null;
        }

        @Override
        public InetAddress getLocalAddress() {
            return this.exchange.getLocalAddress() != null ? this.exchange.getLocalAddress().getAddress() : null;
        }
    }

    protected class RequestHttpHandler
    implements HttpHandler {
        private final Router router;

        public RequestHttpHandler(Router router) {
            this.router = router;
        }

        @Override
        public void handle(final HttpExchange httpExchange) throws IOException {
            StreamServerImpl.this.log.trace("Received HTTP exchange: {} {}", (Object)httpExchange.getRequestMethod(), (Object)httpExchange.getRequestURI());
            this.router.received(new HttpExchangeUpnpStream(this.router.getProtocolFactory(), httpExchange){

                @Override
                protected Connection createConnection() {
                    return new HttpServerConnection(httpExchange);
                }
            });
        }
    }
}

