/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl.jetty;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.jupnp.transport.spi.ServletContainerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyServletContainer
implements ServletContainerAdapter {
    private Logger log = LoggerFactory.getLogger((String)JettyServletContainer.class.getName());
    public static final JettyServletContainer INSTANCE = new JettyServletContainer();
    protected Server server;

    private JettyServletContainer() {
        this.resetServer();
    }

    @Override
    public synchronized void setExecutorService(ExecutorService executorService) {
    }

    @Override
    public synchronized int addConnector(String host, int port) throws IOException {
        return port;
    }

    @Override
    public synchronized void registerServlet(String contextPath, Servlet servlet) {
        if (this.server.getHandler() != null) {
            this.log.trace("Server handler is already set: {}", (Object)this.server.getHandler());
            return;
        }
        this.log.info("Registering UPnP servlet under context path: " + contextPath);
        ServletContextHandler servletHandler = new ServletContextHandler(0);
        if (contextPath != null && contextPath.length() > 0) {
            servletHandler.setContextPath(contextPath);
        }
        ServletHolder s = new ServletHolder(servlet);
        servletHandler.addServlet(s, "/*");
        this.server.setHandler((Handler)servletHandler);
    }

    @Override
    public synchronized void startIfNotRunning() {
        if (!this.server.isStarted() && !this.server.isStarting()) {
            this.log.info("Starting Jetty server... ");
            try {
                this.server.start();
            }
            catch (Exception ex) {
                this.log.error("Couldn't start Jetty server: {}", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public synchronized void stopIfRunning() {
        if (!this.server.isStopped() && !this.server.isStopping()) {
            this.log.info("Stopping Jetty server...");
            try {
                try {
                    this.server.stop();
                }
                catch (Exception ex) {
                    this.log.error("Couldn't stop Jetty server: [}", (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            finally {
                this.resetServer();
            }
        }
    }

    protected void resetServer() {
        this.server = new Server();
    }
}

