/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.spi;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.transport.spi.StreamClient;
import org.jupnp.transport.spi.StreamClientConfiguration;
import org.jupnp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStreamClient<C extends StreamClientConfiguration, REQUEST>
implements StreamClient<C> {
    private final Logger log = LoggerFactory.getLogger(StreamClient.class);

    @Override
    public StreamResponseMessage sendRequest(StreamRequestMessage requestMessage) throws InterruptedException {
        this.log.trace("Preparing HTTP request: " + requestMessage);
        REQUEST request = this.createRequest(requestMessage);
        if (request == null) {
            return null;
        }
        Callable<StreamResponseMessage> callable = this.createCallable(requestMessage, request);
        long start = System.currentTimeMillis();
        Future<StreamResponseMessage> future = this.getConfiguration().getRequestExecutorService().submit(callable);
        try {
            this.log.trace("Waiting " + this.getConfiguration().getTimeoutSeconds() + " seconds for HTTP request to complete: " + requestMessage);
            StreamResponseMessage response = future.get(this.getConfiguration().getTimeoutSeconds(), TimeUnit.SECONDS);
            long elapsed = System.currentTimeMillis() - start;
            this.log.trace("Got HTTP response in {} ms: {}", (Object)elapsed, (Object)requestMessage);
            if (this.getConfiguration().getLogWarningSeconds() > 0 && elapsed > (long)(this.getConfiguration().getLogWarningSeconds() * 1000)) {
                this.log.warn("HTTP request took a long time (" + elapsed + "ms): " + requestMessage);
            }
            StreamResponseMessage streamResponseMessage = response;
            return streamResponseMessage;
        }
        catch (InterruptedException interruptedException) {
            this.log.trace("Interruption, aborting request: " + requestMessage);
            this.abort(request);
            throw new InterruptedException("HTTP request interrupted and aborted");
        }
        catch (TimeoutException timeoutException) {
            this.log.info("Timeout of " + this.getConfiguration().getTimeoutSeconds() + " seconds while waiting for HTTP request to complete, aborting: " + requestMessage);
            this.abort(request);
            return null;
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (!this.logExecutionException(cause)) {
                String message = "HTTP request failed: " + requestMessage;
                if (this.log.isDebugEnabled()) {
                    this.log.warn(message, Exceptions.unwrap(cause));
                } else {
                    this.log.warn(String.valueOf(message) + " (" + Exceptions.unwrap(cause).getMessage() + ")");
                }
            }
            return null;
        }
        finally {
            this.onFinally(request);
        }
    }

    protected abstract REQUEST createRequest(StreamRequestMessage var1);

    protected abstract Callable<StreamResponseMessage> createCallable(StreamRequestMessage var1, REQUEST var2);

    protected abstract void abort(REQUEST var1);

    protected abstract boolean logExecutionException(Throwable var1);

    protected void onFinally(REQUEST request) {
    }
}

