/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.watchers;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.util.BugLog;

public class WatchersInformation
extends FileInfoContainer {
    public static final String WATCH_EDIT = "edit";
    public static final String WATCH_UNEDIT = "unedit";
    public static final String WATCH_COMMIT = "commit";
    public static final String WATCH_TEMP_EDIT = "tedit";
    public static final String WATCH_TEMP_UNEDIT = "tunedit";
    public static final String WATCH_TEMP_COMMIT = "tcommit";
    private final File file;
    private final List userList = new LinkedList();

    public WatchersInformation(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    void addWatcher(String string) {
        String string2 = string.trim();
        int n = (string2 = string2.replace('\t', ' ')).indexOf(32);
        if (n >= 0) {
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            this.userList.add(new Watcher(string3, string4));
        }
    }

    public Iterator getWatchersIterator() {
        return this.userList.iterator();
    }

    public static class Watcher {
        private final String userName;
        private final String watches;
        private boolean watchingEdit;
        private boolean watchingUnedit;
        private boolean watchingCommit;
        private boolean temporaryEdit;
        private boolean temporaryUnedit;
        private boolean temporaryCommit;

        Watcher(String string, String string2) {
            this.userName = string;
            this.watches = string2;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (WatchersInformation.WATCH_EDIT.equals(string3)) {
                    this.watchingEdit = true;
                    continue;
                }
                if (WatchersInformation.WATCH_UNEDIT.equals(string3)) {
                    this.watchingUnedit = true;
                    continue;
                }
                if (WatchersInformation.WATCH_COMMIT.equals(string3)) {
                    this.watchingCommit = true;
                    continue;
                }
                if (WatchersInformation.WATCH_TEMP_COMMIT.equals(string3)) {
                    this.temporaryCommit = true;
                    continue;
                }
                if (WatchersInformation.WATCH_TEMP_EDIT.equals(string3)) {
                    this.temporaryEdit = true;
                    continue;
                }
                if (WatchersInformation.WATCH_TEMP_UNEDIT.equals(string3)) {
                    this.temporaryUnedit = true;
                    continue;
                }
                BugLog.getInstance().bug("unknown = " + string3);
            }
        }

        public String getUserName() {
            return this.userName;
        }

        public String getWatches() {
            return this.watches;
        }

        public boolean isWatchingCommit() {
            return this.watchingCommit;
        }

        public boolean isWatchingEdit() {
            return this.watchingEdit;
        }

        public boolean isWatchingUnedit() {
            return this.watchingUnedit;
        }

        public boolean isTempWatchingCommit() {
            return this.temporaryCommit;
        }

        public boolean isTempWatchingEdit() {
            return this.temporaryEdit;
        }

        public boolean isTempWatchingUnedit() {
            return this.temporaryUnedit;
        }
    }
}

