/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.convert;

import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;

final class LenientStringToEnumConverterFactory
implements ConverterFactory<String, Enum> {
    private static Map<String, List<String>> ALIASES;

    LenientStringToEnumConverterFactory() {
    }

    public <T extends Enum> Converter<String, T> getConverter(Class<T> targetType) {
        Class enumType;
        for (enumType = targetType; enumType != null && !enumType.isEnum(); enumType = enumType.getSuperclass()) {
        }
        Assert.notNull(enumType, () -> "The target type " + targetType.getName() + " does not refer to an enum");
        return new StringToEnum<T>(enumType);
    }

    static {
        LinkedMultiValueMap aliases = new LinkedMultiValueMap();
        aliases.add((Object)"true", (Object)"on");
        aliases.add((Object)"false", (Object)"off");
        ALIASES = Collections.unmodifiableMap(aliases);
    }

    private class StringToEnum<T extends Enum>
    implements Converter<String, T> {
        private final Class<T> enumType;

        StringToEnum(Class<T> enumType) {
            this.enumType = enumType;
        }

        public T convert(String source) {
            if (source.isEmpty()) {
                return null;
            }
            source = source.trim();
            try {
                return Enum.valueOf(this.enumType, source);
            }
            catch (Exception ex) {
                return this.findEnum(source);
            }
        }

        private T findEnum(String source) {
            LinkedHashMap<String, Enum> candidates = new LinkedHashMap<String, Enum>();
            for (Enum candidate : EnumSet.allOf(this.enumType)) {
                candidates.put(this.getCanonicalName(candidate.name()), candidate);
            }
            String name = this.getCanonicalName(source);
            Enum result = (Enum)candidates.get(name);
            if (result != null) {
                return (T)result;
            }
            for (String alias : ALIASES.getOrDefault(name, Collections.emptyList())) {
                result = (Enum)candidates.get(alias);
                if (result == null) continue;
                return (T)result;
            }
            throw new IllegalArgumentException("No enum constant " + this.enumType.getCanonicalName() + "." + source);
        }

        private String getCanonicalName(String name) {
            StringBuilder canonicalName = new StringBuilder(name.length());
            name.chars().filter(Character::isLetterOrDigit).map(Character::toLowerCase).forEach(c -> canonicalName.append((char)c));
            return canonicalName.toString();
        }
    }
}

