/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.integration;

import java.util.Map;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.verifier.util.BodyExtractor;
import org.springframework.integration.transformer.GenericTransformer;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;

class StubRunnerIntegrationTransformer
implements GenericTransformer<Message<?>, Message<?>> {
    private final Contract groovyDsl;

    StubRunnerIntegrationTransformer(Contract groovyDsl) {
        this.groovyDsl = groovyDsl;
    }

    public Message<?> transform(Message<?> source) {
        if (this.groovyDsl.getOutputMessage() == null) {
            return source;
        }
        String payload = BodyExtractor.extractStubValueFrom((Object)this.groovyDsl.getOutputMessage().getBody());
        Map headers = this.groovyDsl.getOutputMessage().getHeaders().asStubSideMap();
        return MessageBuilder.createMessage((Object)payload, (MessageHeaders)new MessageHeaders(headers));
    }
}

