/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.messaging.kafka;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.contract.spec.Contract;
import org.springframework.cloud.contract.stubrunner.messaging.kafka.StubRunnerKafkaMessageSelector;
import org.springframework.cloud.contract.stubrunner.messaging.kafka.StubRunnerKafkaTransformer;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.support.MessageBuilder;

class StubRunnerKafkaRouter
implements MessageListener<Object, Object> {
    private static final Log log = LogFactory.getLog(StubRunnerKafkaRouter.class);
    private final StubRunnerKafkaMessageSelector selector;
    private final BeanFactory beanFactory;
    private final List<Contract> contracts;
    private KafkaTemplate kafkaTemplate;

    StubRunnerKafkaRouter(List<Contract> groovyDsls, BeanFactory beanFactory) {
        this.selector = new StubRunnerKafkaMessageSelector(groovyDsls);
        this.beanFactory = beanFactory;
        this.contracts = groovyDsls;
    }

    private KafkaTemplate kafkaTemplate() {
        if (this.kafkaTemplate == null) {
            this.kafkaTemplate = (KafkaTemplate)this.beanFactory.getBean(KafkaTemplate.class);
        }
        return this.kafkaTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ConsumerRecord<Object, Object> data) {
        Message message;
        Contract dsl;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received message [" + data + "]"));
        }
        if ((dsl = this.selector.matchingContract(message = MessageBuilder.createMessage((Object)data.value(), (MessageHeaders)this.headers(data.headers())))) != null && dsl.getOutputMessage() != null && dsl.getOutputMessage().getSentTo() != null) {
            String destination = (String)dsl.getOutputMessage().getSentTo().getClientValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found a matching contract with an output message. Will send it to the [" + destination + "] destination"));
            }
            Message<?> transform = new StubRunnerKafkaTransformer(this.contracts).transform(dsl);
            String defaultTopic = this.kafkaTemplate().getDefaultTopic();
            try {
                this.kafkaTemplate().setDefaultTopic(destination);
                this.kafkaTemplate().send(transform);
            }
            finally {
                this.kafkaTemplate().setDefaultTopic(defaultTopic);
            }
        }
    }

    private MessageHeaders headers(Headers headers) {
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        for (Header header : headers) {
            map.put(header.key(), header.value());
        }
        return new MessageHeaders(map);
    }

    public void onMessage(ConsumerRecord<Object, Object> data, Acknowledgment acknowledgment) {
        this.onMessage(data);
    }

    public void onMessage(ConsumerRecord<Object, Object> data, Consumer<?, ?> consumer) {
        this.onMessage(data);
    }

    public void onMessage(ConsumerRecord<Object, Object> data, Acknowledgment acknowledgment, Consumer<?, ?> consumer) {
        this.onMessage(data);
    }
}

