/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.range.Range;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.stats.extended.ExtendedStats;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.joda.time.DateTime;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.FacetedPage;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.facet.FacetResult;
import org.springframework.data.elasticsearch.core.facet.result.HistogramResult;
import org.springframework.data.elasticsearch.core.facet.result.IntervalUnit;
import org.springframework.data.elasticsearch.core.facet.result.Range;
import org.springframework.data.elasticsearch.core.facet.result.RangeResult;
import org.springframework.data.elasticsearch.core.facet.result.StatisticalResult;
import org.springframework.data.elasticsearch.core.facet.result.Term;
import org.springframework.data.elasticsearch.core.facet.result.TermResult;

@Deprecated
public abstract class FacetedPageImpl<T>
extends PageImpl<T>
implements FacetedPage<T>,
AggregatedPage<T> {
    private List<FacetResult> facets;
    private Map<String, FacetResult> mapOfFacets = new HashMap<String, FacetResult>();

    public FacetedPageImpl(List<T> content) {
        super(content);
    }

    public FacetedPageImpl(List<T> content, Pageable pageable, long total) {
        super(content, Pageable.unpaged(), total);
    }

    @Override
    public boolean hasFacets() {
        this.processAggregations();
        return this.facets != null && this.facets.size() > 0;
    }

    @Override
    public List<FacetResult> getFacets() {
        this.processAggregations();
        return this.facets;
    }

    @Override
    public FacetResult getFacet(String name) {
        this.processAggregations();
        return this.mapOfFacets.get(name);
    }

    private void addFacet(FacetResult facetResult) {
        this.facets.add(facetResult);
        this.mapOfFacets.put(facetResult.getName(), facetResult);
    }

    private void processAggregations() {
        if (this.facets != null) {
            return;
        }
        this.facets = new ArrayList<FacetResult>();
        Aggregations aggregations = this.getAggregations();
        if (aggregations == null) {
            return;
        }
        for (Aggregation agg : aggregations) {
            this.processAggregation(agg);
        }
    }

    private void processAggregation(Aggregation agg) {
        if (agg instanceof Terms) {
            this.processTermAggregation((Terms)agg);
        }
        if (agg instanceof org.elasticsearch.search.aggregations.bucket.range.Range) {
            this.processRangeAggregation((org.elasticsearch.search.aggregations.bucket.range.Range)agg);
        }
        if (agg instanceof ExtendedStats) {
            this.processExtendedStatsAggregation((ExtendedStats)agg);
        }
        if (agg instanceof Histogram) {
            this.processHistogramAggregation((Histogram)agg);
        }
    }

    private void processTermAggregation(Terms agg) {
        ArrayList<Term> terms = new ArrayList<Term>();
        for (Terms.Bucket t : agg.getBuckets()) {
            terms.add(new Term(t.getKeyAsString(), t.getDocCount()));
        }
        this.addFacet(new TermResult(agg.getName(), terms, terms.size(), agg.getSumOfOtherDocCounts(), 0L));
    }

    private void processRangeAggregation(org.elasticsearch.search.aggregations.bucket.range.Range agg) {
        List buckets = agg.getBuckets();
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (Range.Bucket b : buckets) {
            ExtendedStats rStats = (ExtendedStats)b.getAggregations().get("internal-stats");
            if (rStats != null) {
                Sum sum = (Sum)b.getAggregations().get("range-internal-sum");
                ranges.add(new Range((Double)b.getFrom(), (Double)b.getTo(), b.getDocCount(), sum != null ? sum.getValue() : rStats.getSum(), rStats.getCount(), rStats.getMin(), rStats.getMax()));
                continue;
            }
            ranges.add(new Range((Double)b.getFrom(), (Double)b.getTo(), b.getDocCount(), 0.0, 0.0, 0.0, 0.0));
        }
        this.addFacet(new RangeResult(agg.getName(), ranges));
    }

    private void processExtendedStatsAggregation(ExtendedStats agg) {
        this.addFacet(new StatisticalResult(agg.getName(), agg.getCount(), agg.getMax(), agg.getMin(), agg.getAvg(), agg.getStdDeviation(), agg.getSumOfSquares(), agg.getSum(), agg.getVariance()));
    }

    private void processHistogramAggregation(Histogram agg) {
        ArrayList<IntervalUnit> intervals = new ArrayList<IntervalUnit>();
        for (Histogram.Bucket h : agg.getBuckets()) {
            ExtendedStats hStats = (ExtendedStats)h.getAggregations().get("internal-stats");
            if (hStats != null) {
                intervals.add(new IntervalUnit(((DateTime)h.getKey()).getMillis(), h.getDocCount(), h.getDocCount(), hStats.getSum(), hStats.getAvg(), hStats.getMin(), hStats.getMax()));
                continue;
            }
            intervals.add(new IntervalUnit(((DateTime)h.getKey()).getMillis(), h.getDocCount(), h.getDocCount(), 0.0, 0.0, 0.0, 0.0));
        }
        this.addFacet(new HistogramResult(agg.getName(), intervals));
    }
}

