/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.unidal.dal.jdbc.BizObject;
import org.unidal.dal.jdbc.DataObject;

public class BizObjectHelper {
    private static <T extends BizObject> Constructor<T> getBoConstructor(Class<T> boClass) {
        try {
            Constructor<?>[] cs = boClass.getConstructors();
            for (int i = 0; i < cs.length; ++i) {
                Class<?>[] paramTypes = cs[i].getParameterTypes();
                if (paramTypes.length != 1 || !DataObject.class.isAssignableFrom(paramTypes[0])) continue;
                return cs[i];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new RuntimeException("Can't find a constructor for creating a BO instance from " + boClass);
    }

    public static <S extends DataObject, T extends BizObject> List<S> unwrap(List<T> bos, Class<S> doClass) {
        ArrayList<S> dos = new ArrayList<S>(bos.size());
        for (BizObject bo : bos) {
            dos.add(BizObjectHelper.unwrap(bo, doClass));
        }
        return dos;
    }

    public static <S extends DataObject, T extends BizObject> S unwrap(T bo, Class<S> doClass) {
        return (S)bo.getDo();
    }

    public static <S extends DataObject, T extends BizObject> List<T> wrap(List<S> rows, Class<T> boClass) {
        ArrayList<T> bos = new ArrayList<T>(rows.size());
        for (DataObject row : rows) {
            bos.add(BizObjectHelper.wrap(row, boClass));
        }
        return bos;
    }

    public static <S extends DataObject, T extends BizObject> T wrap(S row, Class<T> boClass) {
        try {
            Constructor<T> c = BizObjectHelper.getBoConstructor(boClass);
            return (T)((BizObject)c.newInstance(row));
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create a BO instance from " + boClass, e);
        }
    }
}

