/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.unidal.dal.jdbc.DataField;

public abstract class DataObject {
    private BitSet m_usages = new BitSet();
    private Map<String, Object> m_queryHints;

    public void afterLoad() {
        this.m_usages.clear();
    }

    public void beforeSave() {
    }

    protected void clearUsage() {
        this.m_usages.clear();
    }

    public Map<String, Object> getQueryHints() {
        return this.m_queryHints;
    }

    public boolean isFieldUsed(DataField field) {
        return this.m_usages.get(field.getIndex());
    }

    protected void setFieldUsed(DataField field, boolean used) {
        if (used) {
            this.m_usages.set(field.getIndex());
        } else {
            this.m_usages.clear(field.getIndex());
        }
    }

    public void setQueryHint(String hint, Object value) {
        if (value == null) {
            if (this.m_queryHints != null) {
                this.m_queryHints.remove(hint);
            }
        } else {
            if (this.m_queryHints == null) {
                this.m_queryHints = new HashMap<String, Object>();
            }
            this.m_queryHints.put(hint, value);
        }
    }
}

