/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc;

import java.util.List;
import org.unidal.dal.jdbc.QueryType;
import org.unidal.dal.jdbc.query.token.Token;
import org.unidal.dal.jdbc.query.token.TokenParser;
import org.unidal.dal.jdbc.raw.RawEntity;

public class QueryDef {
    private String m_name;
    private Class<?> m_entityClass;
    private String m_pattern;
    private QueryType m_type;
    private List<Token> m_tokens;
    private boolean m_storeProcedure;
    private boolean m_raw;

    public QueryDef(String name, Class<?> entityClass, QueryType type, String pattern) {
        this.m_name = name;
        this.m_entityClass = entityClass;
        this.m_type = type;
        this.m_pattern = pattern;
        this.m_raw = RawEntity.class.isAssignableFrom(entityClass);
    }

    public QueryDef(String name, Class<?> entityClass, QueryType type, String pattern, boolean isStoreProcedure) {
        this(name, entityClass, type, pattern);
        this.m_storeProcedure = isStoreProcedure;
    }

    public Class<?> getEntityClass() {
        return this.m_entityClass;
    }

    public String getName() {
        return this.m_name;
    }

    public QueryType getType() {
        return this.m_type;
    }

    public boolean isRaw() {
        return this.m_raw;
    }

    public boolean isStoreProcedure() {
        return this.m_storeProcedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Token> parse(TokenParser parser) {
        if (this.m_tokens == null) {
            QueryDef queryDef = this;
            synchronized (queryDef) {
                if (this.m_tokens == null) {
                    this.m_tokens = parser.parse(this.m_pattern);
                }
            }
        }
        return this.m_tokens;
    }

    public String toString() {
        return this.m_pattern;
    }
}

