/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.configuration;

import java.util.List;
import org.unidal.dal.jdbc.QueryEngine;
import org.unidal.dal.jdbc.annotation.Entity;
import org.unidal.dal.jdbc.datasource.DataSourceProvider;
import org.unidal.dal.jdbc.datasource.DefaultDataSourceProvider;
import org.unidal.dal.jdbc.mapping.SimpleTableProvider;
import org.unidal.dal.jdbc.mapping.TableProvider;
import org.unidal.lookup.configuration.AbstractResourceConfigurator;
import org.unidal.lookup.configuration.Component;
import org.unidal.lookup.configuration.Configuration;

public abstract class AbstractJdbcResourceConfigurator
extends AbstractResourceConfigurator {
    protected void defineDaoComponents(List<Component> all, Class<?>[] daoClasses) {
        for (Class<?> daoClass : daoClasses) {
            all.add(AbstractJdbcResourceConfigurator.C(daoClass).req(new Class[]{QueryEngine.class}));
        }
    }

    protected Component defineJdbcDataSourceConfigurationManagerComponent(String datasourceFile) {
        return AbstractJdbcResourceConfigurator.C(DataSourceProvider.class, DefaultDataSourceProvider.class).config(new Configuration[]{AbstractJdbcResourceConfigurator.E((String)"datasourceFile", (String[])new String[0]).value(datasourceFile)});
    }

    protected Component defineSimpleTableProviderComponent(String dataSource, String logicalTableName) {
        String physicalTableName = logicalTableName.replace('-', '_');
        return this.defineSimpleTableProviderComponent(dataSource, logicalTableName, physicalTableName);
    }

    protected Component defineSimpleTableProviderComponent(String dataSource, String logicalTableName, String physicalTableName) {
        return AbstractJdbcResourceConfigurator.C(TableProvider.class, (Object)logicalTableName, SimpleTableProvider.class).config(new Configuration[]{AbstractJdbcResourceConfigurator.E((String)"physical-table-name", (String[])new String[0]).value(physicalTableName), AbstractJdbcResourceConfigurator.E((String)"data-source-name", (String[])new String[0]).value(dataSource)});
    }

    protected void defineSimpleTableProviderComponents(List<Component> all, String dataSource, Class<?>[] entityClasses) {
        for (Class<?> entityClass : entityClasses) {
            Entity entity = entityClass.getAnnotation(Entity.class);
            String logicalName = entity.logicalName();
            String physicalName = entity.physicalName();
            if (physicalName.length() == 0) {
                logicalName.replace('-', '_');
            }
            all.add(this.defineSimpleTableProviderComponent(dataSource, logicalName, physicalName));
        }
    }
}

