/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.datasource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.dal.jdbc.datasource.DataSource;
import org.unidal.dal.jdbc.datasource.DataSourceManager;
import org.unidal.dal.jdbc.datasource.JdbcDataSourceDescriptor;
import org.unidal.dal.jdbc.datasource.JdbcDataSourceDescriptorManager;
import org.unidal.lookup.ContainerHolder;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=DataSourceManager.class)
public class DefaultDataSourceManager
extends ContainerHolder
implements DataSourceManager {
    @Inject
    private JdbcDataSourceDescriptorManager m_manager;
    private Map<String, DataSource> m_dataSources = new HashMap<String, DataSource>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSource getDataSource(String name) {
        DataSource dataSource = this.m_dataSources.get(name);
        if (dataSource == null) {
            Map<String, DataSource> map = this.m_dataSources;
            synchronized (map) {
                dataSource = this.m_dataSources.get(name);
                if (dataSource == null) {
                    JdbcDataSourceDescriptor descriptor = this.m_manager.getDescriptor(name);
                    if (descriptor == null) {
                        throw new RuntimeException(String.format("No data source(%s) defined!", name));
                    }
                    dataSource = (DataSource)this.lookup(DataSource.class, descriptor.getType());
                    dataSource.initialize(descriptor);
                    this.m_dataSources.put(name, dataSource);
                }
            }
        }
        return dataSource;
    }

    @Override
    public List<String> getDataSourceNames() {
        ArrayList<String> list = new ArrayList<String>(this.m_dataSources.keySet());
        Collections.sort(list);
        return list;
    }
}

