/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.datasource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.unidal.dal.jdbc.datasource.DataSourceProvider;
import org.unidal.dal.jdbc.datasource.model.entity.DataSourcesDef;
import org.unidal.dal.jdbc.datasource.model.transform.DefaultSaxParser;
import org.unidal.helper.Properties;

public class DefaultDataSourceProvider
implements DataSourceProvider,
LogEnabled {
    private String m_datasourceFile;
    private String m_baseDirRef;
    private String m_defaultBaseDir;
    private Logger m_logger;
    private DataSourcesDef m_def;

    @Override
    public DataSourcesDef defineDatasources() {
        if (this.m_def == null && this.m_datasourceFile != null) {
            String baseDir;
            InputStream is = null;
            File file = this.m_datasourceFile.startsWith("/") ? new File(this.m_datasourceFile) : ((baseDir = (String)Properties.forString().fromEnv().fromSystem().getProperty(this.m_baseDirRef, (Object)this.m_defaultBaseDir)) != null ? new File(baseDir, this.m_datasourceFile) : new File(this.m_datasourceFile));
            if (file.canRead()) {
                this.m_logger.info(String.format("Loading data sources from %s ...", file));
                try {
                    is = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {}
            } else {
                this.m_logger.warn(String.format("Data sources configuration(%s) is not found!", file, this.m_datasourceFile));
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.m_datasourceFile);
                if (is == null) {
                    is = this.getClass().getResourceAsStream(this.m_datasourceFile);
                }
                if (is != null) {
                    this.m_logger.info(String.format("Loading data sources from resource(%s)", this.m_datasourceFile));
                }
            }
            if (is != null) {
                try {
                    this.m_def = DefaultSaxParser.parse(is);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error when loading data sources file: " + file, e);
                }
            } else {
                this.m_def = new DataSourcesDef();
            }
        }
        return this.m_def;
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public void setBaseDirRef(String baseDirRef) {
        this.m_baseDirRef = baseDirRef;
    }

    public void setDatasourceFile(String datasourceFile) {
        this.m_datasourceFile = datasourceFile;
    }

    public void setDefaultBaseDir(String defaultBaseDir) {
        this.m_defaultBaseDir = defaultBaseDir;
    }
}

