/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.datasource;

import java.util.LinkedHashMap;
import java.util.Map;
import org.unidal.dal.jdbc.datasource.DataSourceDescriptor;

public class JdbcDataSourceDescriptor
implements DataSourceDescriptor {
    private String m_id;
    private String m_type;
    private Map<String, Object> m_properties = new LinkedHashMap<String, Object>();

    @Override
    public boolean getBooleanProperty(String name, boolean defaultValue) {
        Object value = this.m_properties.get(name);
        if (value != null) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return "true".equals(value);
        }
        return defaultValue;
    }

    @Override
    public double getDoubleProperty(String name, double defaultValue) {
        Object value = this.m_properties.get(name);
        if (value != null) {
            if (value instanceof Double) {
                return (Double)value;
            }
            try {
                return Double.parseDouble(value.toString());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public int getIntProperty(String name, int defaultValue) {
        Object value = this.m_properties.get(name);
        if (value != null) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            try {
                return Integer.parseInt(value.toString());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public long getLongProperty(String name, long defaultValue) {
        Object value = this.m_properties.get(name);
        if (value != null) {
            if (value instanceof Long) {
                return (Long)value;
            }
            try {
                return Long.parseLong(value.toString());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.m_properties;
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        Object value = this.m_properties.get(name);
        if (value != null) {
            return value.toString();
        }
        return defaultValue;
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public void setProperty(String name, Object value) {
        this.m_properties.put(name, value);
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("JdbcDataSourceDescriptor[");
        sb.append("id:").append(this.m_id);
        sb.append(",type:").append(this.m_type);
        sb.append(",properties:").append(this.m_properties);
        sb.append("]");
        return sb.toString();
    }
}

