/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.datasource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.unidal.dal.jdbc.datasource.DataSourceProvider;
import org.unidal.dal.jdbc.datasource.JdbcDataSourceDescriptor;
import org.unidal.dal.jdbc.datasource.model.entity.DataSourceDef;
import org.unidal.dal.jdbc.datasource.model.entity.DataSourcesDef;
import org.unidal.dal.jdbc.datasource.model.entity.PropertiesDef;
import org.unidal.lookup.ContainerHolder;
import org.unidal.lookup.annotation.Named;

@Named
public class JdbcDataSourceDescriptorManager
extends ContainerHolder
implements Initializable {
    private Map<String, JdbcDataSourceDescriptor> m_descriptors = new HashMap<String, JdbcDataSourceDescriptor>();
    private List<DataSourceProvider> m_providers;

    protected JdbcDataSourceDescriptor buildDescriptor(DataSourceDef ds) {
        JdbcDataSourceDescriptor d = new JdbcDataSourceDescriptor();
        PropertiesDef properties = ds.getProperties();
        String url = properties.getUrl();
        String connectionProperties = properties.getConnectionProperties();
        if (connectionProperties != null && connectionProperties.length() > 0) {
            d.setProperty("url", url + "?" + connectionProperties);
        } else {
            d.setProperty("url", url);
        }
        d.setId(ds.getId());
        d.setType(ds.getType());
        d.setProperty("driver", properties.getDriver());
        d.setProperty("user", properties.getUser());
        d.setProperty("password", properties.getPassword());
        d.setProperty("login-timeout", this.toTime(ds.getConnectionTimeout()));
        d.setProperty("max-idle-time", this.toTime(ds.getIdleTimeout()));
        d.setProperty("min-pool-size", ds.getMinimumPoolSize());
        d.setProperty("max-pool-size", ds.getMaximumPoolSize());
        return d;
    }

    private DataSourceDef findDataSource(String id) {
        for (DataSourceProvider provider : this.m_providers) {
            DataSourceDef ds;
            DataSourcesDef def = provider.defineDatasources();
            if (def == null || (ds = def.findDataSource(id)) == null) continue;
            return ds;
        }
        return null;
    }

    public List<String> getDataSourceNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (DataSourceProvider provider : this.m_providers) {
            DataSourcesDef def = provider.defineDatasources();
            if (def == null) continue;
            for (String name : def.getDataSourcesMap().keySet()) {
                if (names.contains(name)) continue;
                names.add(name);
            }
        }
        return names;
    }

    public JdbcDataSourceDescriptor getDescriptor(String id) {
        DataSourceDef ds;
        JdbcDataSourceDescriptor configuration = this.m_descriptors.get(id);
        if (configuration == null && (ds = this.findDataSource(id)) != null) {
            configuration = this.buildDescriptor(ds);
            this.m_descriptors.put(id, configuration);
        }
        return configuration;
    }

    public void initialize() throws InitializationException {
        this.m_providers = new ArrayList<DataSourceProvider>(this.lookupList(DataSourceProvider.class));
        if (this.m_providers.isEmpty()) {
            throw new InitializationException("No DataSourceProvider found!");
        }
    }

    protected int toTime(String source) {
        int time = 0;
        int len = source == null ? 0 : source.length();
        int num = 0;
        block6: for (int i = 0; i < len; ++i) {
            char ch = source.charAt(i);
            switch (ch) {
                case 'd': {
                    time += num * 24 * 60 * 60;
                    num = 0;
                    continue block6;
                }
                case 'h': {
                    time += num * 60 * 60;
                    num = 0;
                    continue block6;
                }
                case 'm': {
                    time += num * 60;
                    num = 0;
                    continue block6;
                }
                case 's': {
                    time += num;
                    num = 0;
                    continue block6;
                }
                default: {
                    if (ch >= '0' && ch <= '9') {
                        num = num * 10 + (ch - 48);
                        continue block6;
                    }
                    throw new IllegalArgumentException("Invalid character found: " + ch + ", should be one of [0-9][dhms]");
                }
            }
        }
        return time;
    }
}

