/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.datasource.model.entity;

import org.unidal.dal.jdbc.datasource.model.BaseEntity;
import org.unidal.dal.jdbc.datasource.model.IVisitor;
import org.unidal.dal.jdbc.datasource.model.entity.PropertiesDef;

public class DataSourceDef
extends BaseEntity<DataSourceDef> {
    private String m_id;
    private String m_type = "jdbc";
    private Integer m_minimumPoolSize = 1;
    private Integer m_maximumPoolSize = 3;
    private String m_connectionTimeout = "1s";
    private String m_idleTimeout = "30m";
    private Integer m_statementCacheSize = 1000;
    private PropertiesDef m_properties;

    public DataSourceDef() {
    }

    public DataSourceDef(String id) {
        this.m_id = id;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitDataSource(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DataSourceDef) {
            DataSourceDef _o = (DataSourceDef)obj;
            return this.equals(this.m_id, _o.getId());
        }
        return false;
    }

    public String getConnectionTimeout() {
        return this.m_connectionTimeout;
    }

    public String getId() {
        return this.m_id;
    }

    public String getIdleTimeout() {
        return this.m_idleTimeout;
    }

    public Integer getMaximumPoolSize() {
        return this.m_maximumPoolSize;
    }

    public Integer getMinimumPoolSize() {
        return this.m_minimumPoolSize;
    }

    public PropertiesDef getProperties() {
        return this.m_properties;
    }

    public Integer getStatementCacheSize() {
        return this.m_statementCacheSize;
    }

    public String getType() {
        return this.m_type;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    @Override
    public void mergeAttributes(DataSourceDef other) {
        this.assertAttributeEquals(other, "data-source", "id", this.m_id, other.getId());
        if (other.getType() != null) {
            this.m_type = other.getType();
        }
    }

    public DataSourceDef setConnectionTimeout(String connectionTimeout) {
        this.m_connectionTimeout = connectionTimeout;
        return this;
    }

    public DataSourceDef setId(String id) {
        this.m_id = id;
        return this;
    }

    public DataSourceDef setIdleTimeout(String idleTimeout) {
        this.m_idleTimeout = idleTimeout;
        return this;
    }

    public DataSourceDef setMaximumPoolSize(Integer maximumPoolSize) {
        this.m_maximumPoolSize = maximumPoolSize;
        return this;
    }

    public DataSourceDef setMinimumPoolSize(Integer minimumPoolSize) {
        this.m_minimumPoolSize = minimumPoolSize;
        return this;
    }

    public DataSourceDef setProperties(PropertiesDef properties) {
        this.m_properties = properties;
        return this;
    }

    public DataSourceDef setStatementCacheSize(Integer statementCacheSize) {
        this.m_statementCacheSize = statementCacheSize;
        return this;
    }

    public DataSourceDef setType(String type) {
        this.m_type = type;
        return this;
    }
}

