/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.datasource.model.transform;

import java.util.ArrayList;
import java.util.List;
import org.unidal.dal.jdbc.datasource.model.entity.DataSourceDef;
import org.unidal.dal.jdbc.datasource.model.entity.DataSourcesDef;
import org.unidal.dal.jdbc.datasource.model.entity.PropertiesDef;
import org.unidal.dal.jdbc.datasource.model.transform.ILinker;

public class DefaultLinker
implements ILinker {
    private boolean m_deferrable;
    private List<Runnable> m_deferedJobs = new ArrayList<Runnable>();

    public DefaultLinker(boolean deferrable) {
        this.m_deferrable = deferrable;
    }

    public void finish() {
        for (Runnable job : this.m_deferedJobs) {
            job.run();
        }
    }

    @Override
    public boolean onDataSource(final DataSourcesDef parent, final DataSourceDef dataSource) {
        if (this.m_deferrable) {
            this.m_deferedJobs.add(new Runnable(){

                @Override
                public void run() {
                    parent.addDataSource(dataSource);
                }
            });
        } else {
            parent.addDataSource(dataSource);
        }
        return true;
    }

    @Override
    public boolean onProperties(DataSourceDef parent, PropertiesDef properties) {
        parent.setProperties(properties);
        return true;
    }
}

