/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.datasource.model.transform;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.unidal.dal.jdbc.datasource.model.IEntity;
import org.unidal.dal.jdbc.datasource.model.entity.DataSourceDef;
import org.unidal.dal.jdbc.datasource.model.entity.DataSourcesDef;
import org.unidal.dal.jdbc.datasource.model.entity.PropertiesDef;
import org.unidal.dal.jdbc.datasource.model.transform.DefaultLinker;
import org.unidal.dal.jdbc.datasource.model.transform.DefaultSaxMaker;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultSaxParser
extends DefaultHandler {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DefaultSaxMaker m_maker = new DefaultSaxMaker();
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private IEntity<?> m_entity;
    private StringBuilder m_text = new StringBuilder();

    public static DataSourcesDef parse(InputSource is) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(DataSourcesDef.class, is);
    }

    public static DataSourcesDef parse(InputStream in) throws SAXException, IOException {
        return DefaultSaxParser.parse(new InputSource(in));
    }

    public static DataSourcesDef parse(Reader reader) throws SAXException, IOException {
        return DefaultSaxParser.parse(new InputSource(reader));
    }

    public static DataSourcesDef parse(String xml) throws SAXException, IOException {
        return DefaultSaxParser.parse(new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, String xml) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(type, new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, InputSource is) throws SAXException, IOException {
        try {
            DefaultSaxParser handler = new DefaultSaxParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            return (T)handler.getEntity();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX parser instance!", e);
        }
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_text.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.m_linker.finish();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            Object currentObj = this.m_objs.pop();
            String currentTag = this.m_tags.pop();
            if (currentObj instanceof DataSourceDef) {
                DataSourceDef dataSource = (DataSourceDef)currentObj;
                if ("minimum-pool-size".equals(currentTag)) {
                    dataSource.setMinimumPoolSize(this.convert(Integer.class, this.getText(), null));
                } else if ("maximum-pool-size".equals(currentTag)) {
                    dataSource.setMaximumPoolSize(this.convert(Integer.class, this.getText(), null));
                } else if ("connection-timeout".equals(currentTag)) {
                    dataSource.setConnectionTimeout(this.getText());
                } else if ("idle-timeout".equals(currentTag)) {
                    dataSource.setIdleTimeout(this.getText());
                } else if ("statement-cache-size".equals(currentTag)) {
                    dataSource.setStatementCacheSize(this.convert(Integer.class, this.getText(), null));
                }
            } else if (currentObj instanceof PropertiesDef) {
                PropertiesDef properties = (PropertiesDef)currentObj;
                if ("driver".equals(currentTag)) {
                    properties.setDriver(this.getText());
                } else if ("url".equals(currentTag)) {
                    properties.setUrl(this.getText());
                } else if ("user".equals(currentTag)) {
                    properties.setUser(this.getText());
                } else if ("password".equals(currentTag)) {
                    properties.setPassword(this.getText());
                } else if ("connectionProperties".equals(currentTag)) {
                    properties.setConnectionProperties(this.getText());
                }
            }
        }
        this.m_text.setLength(0);
    }

    private IEntity<?> getEntity() {
        return this.m_entity;
    }

    protected String getText() {
        return this.m_text.toString();
    }

    private void parseForDataSource(DataSourceDef parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("minimum-pool-size".equals(qName) || "maximum-pool-size".equals(qName) || "connection-timeout".equals(qName) || "idle-timeout".equals(qName) || "statement-cache-size".equals(qName)) {
            this.m_objs.push(parentObj);
        } else if ("properties".equals(qName)) {
            PropertiesDef properties = this.m_maker.buildProperties(attributes);
            this.m_linker.onProperties(parentObj, properties);
            this.m_objs.push(properties);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under data-source!", qName));
        }
        this.m_tags.push(qName);
    }

    private void parseForDataSources(DataSourcesDef parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"data-source".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under data-sources!", qName));
        }
        DataSourceDef dataSource = this.m_maker.buildDataSource(attributes);
        this.m_linker.onDataSource(parentObj, dataSource);
        this.m_objs.push(dataSource);
        this.m_tags.push(qName);
    }

    private void parseForProperties(PropertiesDef parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!("driver".equals(qName) || "url".equals(qName) || "user".equals(qName) || "password".equals(qName) || "connectionProperties".equals(qName))) {
            throw new SAXException(String.format("Element(%s) is not expected under properties!", qName));
        }
        this.m_objs.push(parentObj);
        this.m_tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("data-sources".equals(qName)) {
            DataSourcesDef dataSources;
            this.m_entity = dataSources = this.m_maker.buildDataSources(attributes);
            this.m_objs.push(dataSources);
            this.m_tags.push(qName);
        } else if ("data-source".equals(qName)) {
            DataSourceDef dataSource;
            this.m_entity = dataSource = this.m_maker.buildDataSource(attributes);
            this.m_objs.push(dataSource);
            this.m_tags.push(qName);
        } else if ("properties".equals(qName)) {
            PropertiesDef properties;
            this.m_entity = properties = this.m_maker.buildProperties(attributes);
            this.m_objs.push(properties);
            this.m_tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.m_objs.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.m_objs.peek();
            String tag = this.m_tags.peek();
            if (parent instanceof DataSourcesDef) {
                this.parseForDataSources((DataSourcesDef)parent, tag, qName, attributes);
            } else if (parent instanceof DataSourceDef) {
                this.parseForDataSource((DataSourceDef)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof PropertiesDef)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForProperties((PropertiesDef)parent, tag, qName, attributes);
            }
        }
        this.m_text.setLength(0);
    }
}

