/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.engine;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.dal.jdbc.DataObject;
import org.unidal.dal.jdbc.QueryDef;
import org.unidal.dal.jdbc.QueryEngine;
import org.unidal.dal.jdbc.Readset;
import org.unidal.dal.jdbc.Updateset;
import org.unidal.dal.jdbc.engine.DefaultQueryContext;
import org.unidal.dal.jdbc.engine.QueryContext;
import org.unidal.dal.jdbc.entity.EntityInfo;
import org.unidal.dal.jdbc.entity.EntityInfoManager;
import org.unidal.dal.jdbc.query.QueryExecutor;
import org.unidal.dal.jdbc.query.QueryResolver;
import org.unidal.dal.jdbc.transaction.TransactionManager;
import org.unidal.lookup.ContainerHolder;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=QueryEngine.class)
public class DefaultQueryEngine
extends ContainerHolder
implements QueryEngine {
    @Inject
    private EntityInfoManager m_entityManager;
    @Inject
    private QueryExecutor m_queryExecutor;
    @Inject
    private TransactionManager m_transactionManager;
    @Inject
    private QueryResolver m_queryResolver;

    protected <T extends DataObject> QueryContext createContext(QueryDef query, T proto) {
        DefaultQueryContext ctx = new DefaultQueryContext();
        EntityInfo enityInfo = this.m_entityManager.getEntityInfo(query.getEntityClass());
        Map<String, Object> queryHints = this.getQueryHints(query, proto);
        ctx.setQuery(query);
        ctx.setProto(proto);
        ctx.setEntityInfo(enityInfo);
        ctx.setQueryHints(queryHints);
        return ctx;
    }

    @Override
    public <T extends DataObject> int[] deleteBatch(QueryDef query, T[] protos) throws DalException {
        if (protos.length == 0) {
            return new int[0];
        }
        QueryContext ctx = this.createContext(query, protos[0]);
        this.m_queryResolver.resolve(ctx);
        return this.m_queryExecutor.executeUpdateBatch(ctx, (DataObject[])protos);
    }

    @Override
    public <T extends DataObject> int deleteSingle(QueryDef query, T proto) throws DalException {
        QueryContext ctx = this.createContext(query, proto);
        this.m_queryResolver.resolve(ctx);
        return this.m_queryExecutor.executeUpdate(ctx);
    }

    protected Map<String, Object> getQueryHints(QueryDef query, DataObject proto) {
        Map<String, Object> hints = proto.getQueryHints();
        if (hints == null) {
            hints = new HashMap<String, Object>();
        }
        hints.put("QUERY", query);
        hints.put("DATA_OBJECT", proto);
        return hints;
    }

    @Override
    public <T extends DataObject> int[] insertBatch(QueryDef query, T[] protos) throws DalException {
        if (protos.length == 0) {
            return new int[0];
        }
        QueryContext ctx = this.createContext(query, protos[0]);
        this.m_queryResolver.resolve(ctx);
        return this.m_queryExecutor.executeUpdateBatch(ctx, (DataObject[])protos);
    }

    @Override
    public <T extends DataObject> int insertSingle(QueryDef query, T proto) throws DalException {
        QueryContext ctx = this.createContext(query, proto);
        this.m_queryResolver.resolve(ctx);
        return this.m_queryExecutor.executeUpdate(ctx);
    }

    @Override
    public <T extends DataObject> List<T> queryMultiple(QueryDef query, T proto, Readset<?> readset) throws DalException {
        QueryContext ctx = this.createContext(query, proto);
        ctx.setReadset(readset);
        this.m_queryResolver.resolve(ctx);
        return this.m_queryExecutor.executeQuery(ctx);
    }

    @Override
    public <T extends DataObject> T querySingle(QueryDef query, T proto, Readset<?> readset) throws DalException {
        QueryContext ctx = this.createContext(query, proto);
        ctx.setReadset(readset);
        ctx.setFetchSize(1);
        this.m_queryResolver.resolve(ctx);
        List results = this.m_queryExecutor.executeQuery(ctx);
        if (results.isEmpty()) {
            throw new DalNotFoundException("No record has been found for " + proto);
        }
        return (T)((DataObject)results.get(0));
    }

    @Override
    public <T extends DataObject> int[] updateBatch(QueryDef query, T[] protos, Updateset<?> updateset) throws DalException {
        if (protos.length == 0) {
            return new int[0];
        }
        QueryContext ctx = this.createContext(query, protos[0]);
        ctx.setUpdateset(updateset);
        this.m_queryResolver.resolve(ctx);
        return this.m_queryExecutor.executeUpdateBatch(ctx, (DataObject[])protos);
    }

    @Override
    public <T extends DataObject> int updateSingle(QueryDef query, T proto, Updateset<?> updateset) throws DalException {
        QueryContext ctx = this.createContext(query, proto);
        ctx.setUpdateset(updateset);
        this.m_queryResolver.resolve(ctx);
        return this.m_queryExecutor.executeUpdate(ctx);
    }
}

