/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.entity;

import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.unidal.dal.jdbc.DalRuntimeException;
import org.unidal.dal.jdbc.DataField;
import org.unidal.dal.jdbc.DataObject;
import org.unidal.dal.jdbc.entity.DataObjectAccessor;
import org.unidal.dal.jdbc.entity.DataObjectNaming;
import org.unidal.dal.jdbc.raw.RawDataObject;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=DataObjectAccessor.class)
public class DefaultDataObjectAccessor
implements DataObjectAccessor,
LogEnabled {
    @Inject
    private DataObjectNaming m_naming;
    private Map<Class<? extends DataObject>, Map<String, Method>> m_getMap = new HashMap<Class<? extends DataObject>, Map<String, Method>>();
    private Map<Class<? extends DataObject>, Map<String, Method>> m_setMap = new HashMap<Class<? extends DataObject>, Map<String, Method>>();
    private Logger m_logger;

    protected Object convert(Object value, Class<?> clazz) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == clazz) {
            return value;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.valueOf(value.toString());
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            return Long.valueOf(value.toString());
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return Double.valueOf(value.toString());
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            return Float.valueOf(value.toString());
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            String val = value.toString();
            if (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("1") || val.equalsIgnoreCase("on") || val.equalsIgnoreCase("T") || val.equalsIgnoreCase("Y")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (clazz == Date.class) {
            if (value instanceof Timestamp) {
                return value;
            }
        } else if (clazz == byte[].class && value instanceof Blob) {
            Blob blob = (Blob)value;
            try {
                return blob.getBytes(0L, (int)blob.length());
            }
            catch (Exception e) {
                throw new DalRuntimeException("Error when converting Blob to byte[]!", e);
            }
        }
        this.m_logger.error("Can't convert type from " + value.getClass() + " to " + clazz + " at " + this.getClass());
        return value;
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public Object getFieldValue(DataObject dataObject, DataField dataField) {
        String name;
        Method method;
        if (dataObject instanceof RawDataObject) {
            return ((RawDataObject)dataObject).getFieldValue(dataField.getName());
        }
        Class<?> clazz = dataObject.getClass();
        Map<String, Method> methods = this.m_getMap.get(clazz);
        if (methods == null) {
            methods = new HashMap<String, Method>();
            this.m_getMap.put(clazz, methods);
        }
        if ((method = methods.get(name = dataField.getName())) == null) {
            method = this.m_naming.getGetMethod(clazz, name);
            methods.put(name, method);
        }
        try {
            Object value = method.invoke((Object)dataObject, new Object[0]);
            return value;
        }
        catch (Exception e) {
            throw new DalRuntimeException("Error when getting value of field(" + name + ") of " + clazz, e);
        }
    }

    @Override
    public <T extends DataObject> T newInstance(Class<T> clazz) {
        try {
            return (T)((DataObject)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new DalRuntimeException("Error when creating new instance of " + clazz, e);
        }
    }

    public void setFieldValue(DataObject dataObject, DataField dataField, Object value) {
        String name;
        Method method;
        if (dataObject instanceof RawDataObject) {
            ((RawDataObject)dataObject).setFieldUsed(dataField, true);
            ((RawDataObject)dataObject).setFieldValue(dataField.getName(), value);
            return;
        }
        Class<?> clazz = dataObject.getClass();
        Map<String, Method> methods = this.m_setMap.get(clazz);
        if (methods == null) {
            methods = new HashMap<String, Method>();
            this.m_setMap.put(clazz, methods);
        }
        if ((method = methods.get(name = dataField.getName())) == null) {
            method = this.m_naming.getSetMethod(clazz, name);
            methods.put(name, method);
        }
        Class<?> type = method.getParameterTypes()[0];
        Object newValue = this.convert(value, type);
        try {
            if (newValue != null) {
                method.invoke((Object)dataObject, newValue);
            }
        }
        catch (Exception e) {
            throw new DalRuntimeException("Error when setting value of field(" + name + ") of " + clazz + ", required: " + type + ", but: " + value.getClass(), e);
        }
    }
}

