/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.entity;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.unidal.dal.jdbc.DalRuntimeException;
import org.unidal.dal.jdbc.DataField;
import org.unidal.dal.jdbc.DataObject;
import org.unidal.dal.jdbc.engine.QueryContext;
import org.unidal.dal.jdbc.entity.DataObjectAccessor;
import org.unidal.dal.jdbc.entity.DataObjectAssembly;
import org.unidal.dal.jdbc.entity.DataObjectNaming;
import org.unidal.dal.jdbc.raw.RawEntity;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.annotation.Named;

@Named(type=DataObjectAssembly.class)
public class DefaultDataObjectAssembly
implements DataObjectAssembly {
    @Inject
    private DataObjectAccessor m_accessor;
    @Inject
    private DataObjectNaming m_naming;
    private Map<Class<?>, Map<String, Method>> m_subObjectsMap = new HashMap();
    private Map<Method, DataObject> m_cache = new HashMap<Method, DataObject>();

    public <T extends DataObject> T newRow(T proto, List<String> subObjectNames, List<DataObject> result) {
        Class<?> masterClass = proto.getClass();
        Map<String, Method> subObjects = this.m_subObjectsMap.get(masterClass);
        if (subObjects == null) {
            subObjects = new LinkedHashMap<String, Method>();
            this.m_subObjectsMap.put(masterClass, subObjects);
        }
        Object row = this.m_accessor.newInstance(masterClass);
        this.m_cache.clear();
        for (String subObjectName : subObjectNames) {
            if (subObjectName != null) {
                DataObject subObject;
                Method setMethod = subObjects.get(subObjectName);
                if (setMethod == null) {
                    setMethod = this.m_naming.getSetMethod(masterClass, subObjectName);
                    subObjects.put(subObjectName, setMethod);
                }
                if ((subObject = this.m_cache.get(setMethod)) == null) {
                    Class<?> subObjectType = setMethod.getParameterTypes()[0];
                    subObject = this.m_accessor.newInstance(subObjectType);
                    try {
                        setMethod.invoke(row, subObject);
                    }
                    catch (Exception e) {
                        throw new DalRuntimeException("Error when setting SubObject(" + subObject + " to DataObject(" + row + ")");
                    }
                    this.m_cache.put(setMethod, subObject);
                }
                result.add(subObject);
                continue;
            }
            result.add((DataObject)row);
        }
        return (T)row;
    }

    private void prepareOutFields(QueryContext ctx, ResultSet rs) throws SQLException {
        ResultSetMetaData metadata = rs.getMetaData();
        List<DataField> outFields = ctx.getOutFields();
        int count = metadata.getColumnCount();
        for (int i = 1; i <= count; ++i) {
            String name = metadata.getColumnName(i);
            DataField field = new DataField(name);
            field.setEntityClass(RawEntity.class);
            field.setIndex(i - 1);
            outFields.add(field);
        }
    }

    @Override
    public <T extends DataObject> List<T> assemble(QueryContext ctx, ResultSet rs) throws SQLException {
        List<DataField> outFields = ctx.getOutFields();
        if (ctx.getQuery().isRaw()) {
            this.prepareOutFields(ctx, rs);
        }
        List<String> outSubObjectNames = ctx.getOutSubObjectNames();
        ArrayList<DataObject> subObjects = new ArrayList<DataObject>();
        DataObject proto = ctx.getProto();
        ArrayList<DataObject> rows = new ArrayList<DataObject>();
        while (rs.next()) {
            subObjects.clear();
            DataObject row = this.newRow(proto, outSubObjectNames, subObjects);
            int len = outFields.size();
            for (int i = 0; i < len; ++i) {
                DataField field = outFields.get(i);
                if (ctx.getQuery().isRaw()) {
                    this.m_accessor.setFieldValue(row, field, rs.getObject(i + 1));
                    continue;
                }
                DataObject subObject = (DataObject)subObjects.get(i);
                this.m_accessor.setFieldValue(subObject, field, rs.getObject(i + 1));
            }
            row.afterLoad();
            rows.add(row);
        }
        rs.close();
        return rows;
    }
}

