/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.dal.jdbc.entity;

import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Date;
import org.unidal.dal.jdbc.DalRuntimeException;
import org.unidal.dal.jdbc.DataObject;
import org.unidal.dal.jdbc.entity.DataObjectNaming;
import org.unidal.lookup.annotation.Named;

@Named(type=DataObjectNaming.class)
public class DefaultDataObjectNaming
implements DataObjectNaming {
    @Override
    public Method getGetMethod(Class<? extends DataObject> clazz, String name) {
        Method method = null;
        try {
            method = clazz.getMethod(this.normalize("get", name, null), new Class[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            method = clazz.getMethod(this.normalize("is", name, null), new Class[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (method == null) {
            throw new DalRuntimeException("No Getter for DataField(" + name + ") defined at " + clazz);
        }
        return method;
    }

    @Override
    public Method getSetMethod(Class<? extends DataObject> clazz, String name) {
        Method[] methods;
        String methodName = this.normalize("set", name, null);
        for (Method method : methods = clazz.getMethods()) {
            Class<?>[] parameterTypes;
            if (!method.getName().equals(methodName) || (parameterTypes = method.getParameterTypes()).length != 1) continue;
            return method;
        }
        throw new DalRuntimeException("No Setter for DataField(" + name + ") defined at " + clazz);
    }

    protected Method getSetMethod(Class<? extends DataObject> clazz, String name, Object value) {
        Method method = this.getSetMethod(clazz, name);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?> type = this.typeToClass(parameterTypes[0]);
        if (value == null || this.isAssignable(value.getClass(), type)) {
            return method;
        }
        throw new DalRuntimeException("No Setter for DataField(" + name + ") defined at " + clazz);
    }

    protected boolean isAssignable(Class<?> from, Class<?> to) {
        if (from == to) {
            return true;
        }
        return to == Long.class && from == Integer.class;
    }

    protected Class<?> typeToClass(Class<?> type) {
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Void.TYPE) {
            return Void.class;
        }
        if (type == Date.class) {
            return Timestamp.class;
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String normalize(String prefix, String rawFieldName, String suffix) {
        int len = rawFieldName == null ? 0 : rawFieldName.length();
        StringBuilder sb = new StringBuilder(len);
        boolean firstChar = true;
        boolean hyphen = false;
        StringBuilder stringBuilder = sb;
        synchronized (stringBuilder) {
            if (prefix != null) {
                sb.append(prefix);
            }
            for (int i = 0; i < len; ++i) {
                char ch = rawFieldName.charAt(i);
                if (ch == '-' || ch == '_') {
                    hyphen = true;
                    continue;
                }
                if (firstChar) {
                    firstChar = false;
                    sb.append(Character.toUpperCase(ch));
                    continue;
                }
                if (hyphen) {
                    hyphen = false;
                    sb.append(Character.toUpperCase(ch));
                    continue;
                }
                sb.append(ch);
            }
            if (suffix != null) {
                sb.append(suffix);
            }
        }
        return sb.toString();
    }
}

